/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jtester.annotations.SpringInitMethod;

public class JTesterHelper {
    public static void invokeSpringInitMethod(Object test) {
        Method[] methods;
        Class<?> claz = test.getClass();
        for (Method method : methods = claz.getDeclaredMethods()) {
            boolean isSpringInitMethod = JTesterHelper.isSpringInitMethod(method);
            if (!isSpringInitMethod) continue;
            boolean accessible = method.isAccessible();
            method.setAccessible(true);
            try {
                method.invoke(test, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("invoke @SpringInitMethod " + method.getName() + " error.", e);
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    private static boolean isSpringInitMethod(Method method) {
        SpringInitMethod springInitMethod = method.getAnnotation(SpringInitMethod.class);
        if (springInitMethod == null) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isPublic(mod)) {
            throw new RuntimeException("to avoid being regarded as @Test method, the @SpringInitMethod can't be public.");
        }
        Class<?>[] paras = method.getParameterTypes();
        if (paras.length != 0) {
            throw new RuntimeException("the @SpringInitMethod can't have any parameter.");
        }
        return true;
    }
}

