/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core;

import java.lang.reflect.Method;
import org.jtester.module.TestListener;
import org.jtester.module.core.CoreModule;
import org.jtester.utility.JTesterLogger;

public class ListenerExecutor {
    private static final String TEST_CLAZZ_INFO = "%s executing test class[%s] in thread[%d].";
    private static final String TEST_METHOD_INFO = "%s executing test method[%s . %s ()] in thread[%d].";

    public static Throwable executeSetupClass(Class testClazz) {
        String hits = String.format(TEST_CLAZZ_INFO, "Begin", testClazz.getName(), Thread.currentThread().getId());
        JTesterLogger.info("\n\n\n" + hits);
        try {
            ListenerExecutor.getTestListener().setupClass(testClazz);
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e;
        }
    }

    public static Throwable executeSetupMethod(Object testedObject, Method testedMethod) {
        String hits = String.format(TEST_METHOD_INFO, "Begin", testedObject.getClass().getName(), testedMethod.getName(), Thread.currentThread().getId());
        JTesterLogger.info("\n" + hits);
        try {
            ListenerExecutor.getTestListener().setupMethod(testedObject, testedMethod);
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e;
        }
    }

    public static Throwable executeBeforeMethodRunningEvents(Object testedObject, Method testedMethod) {
        try {
            ListenerExecutor.getTestListener().beforeMethodRunning(testedObject, testedMethod);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public static Throwable executeAfterMethodRunnedEvents(Object testedObject, Method testedMethod, Throwable error) {
        try {
            ListenerExecutor.getTestListener().afterMethodRunned(testedObject, testedMethod, error);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable executeTeardownMethod(Object testedObject, Method testedMethod) {
        String hits = String.format(TEST_METHOD_INFO, "End", testedObject.getClass().getName(), testedMethod.getName(), Thread.currentThread().getId());
        try {
            ListenerExecutor.getTestListener().teardownMethod(testedObject, testedMethod);
            Throwable throwable = null;
            return throwable;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Throwable throwable = e;
            return throwable;
        }
        finally {
            JTesterLogger.info(hits + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable executeTeardownClass(Object testedObject) {
        String clazName = testedObject.getClass().getName();
        String hits = String.format(TEST_CLAZZ_INFO, "End", clazName, Thread.currentThread().getId());
        try {
            ListenerExecutor.getTestListener().teardownClass(testedObject);
            Throwable throwable = null;
            return throwable;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Throwable throwable = e;
            return throwable;
        }
        finally {
            JTesterLogger.info(hits + "\n");
        }
    }

    private static TestListener getTestListener() {
        return CoreModule.getTestListener();
    }
}

