/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jtester.annotations.Transactional;
import org.jtester.core.context.TransactionManager;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.exception.MultipleException;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.core.helper.SpringModuleHelper;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.module.spring.strategy.cleaner.SpringBeanCleaner;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;

public class TestedObject {
    private static final TestedObject context = new TestedObject();
    private Class testedClazz;
    private Object testedObject;
    private Method testedMethod;
    private List<Throwable> errors;
    private static Map<Class, ThreadLocal<TransactionManager>> localTransactionManager = new ConcurrentHashMap<Class, ThreadLocal<TransactionManager>>();
    private static Map<Class, JTesterBeanFactory> springBeanFactories = new HashMap<Class, JTesterBeanFactory>();

    public static final TestedObject context() {
        return context;
    }

    public static final void setContext(Class claz) {
        TestedObject.context.testedClazz = claz;
        TestedObject.context.testedObject = null;
        TestedObject.context.testedMethod = null;
    }

    public static final void setContext(Object testedObject, Method testedMethod) {
        if (testedObject == null) {
            throw new RuntimeException("tested object can't be null.");
        }
        TestedObject.context.testedClazz = testedObject.getClass();
        TestedObject.context.testedObject = testedObject;
        TestedObject.context.testedMethod = testedMethod;
        TestedObject.context.errors = new ArrayList<Throwable>();
    }

    public static final void addThrowable(Throwable e) {
        if (TestedObject.context.errors == null) {
            TestedObject.context.errors = new ArrayList<Throwable>();
        }
        TestedObject.context.errors.add(e);
    }

    public static RuntimeException getMultipleException(Throwable cause) {
        if (TestedObject.context.errors == null || TestedObject.context.errors.size() == 0) {
            return ExceptionWrapper.wrapWithRuntimeException(cause);
        }
        MultipleException exception = new MultipleException(cause);
        for (Throwable e : TestedObject.context.errors) {
            exception.addException(e);
        }
        return exception;
    }

    public static final void cleanContext() {
        TestedObject.context.testedClazz = null;
        TestedObject.context.testedObject = null;
        TestedObject.context.testedMethod = null;
        TestedObject.context.errors = null;
    }

    private TestedObject() {
    }

    public static String currTestedClazzName() {
        if (TestedObject.context.testedClazz == null) {
            throw new RuntimeException("tested class can't be null.");
        }
        return TestedObject.context.testedClazz.getName();
    }

    public static String currTestedMethodName() {
        if (TestedObject.context.testedClazz == null) {
            throw new RuntimeException("tested class can't be null.");
        }
        return TestedObject.context.testedClazz.getName() + "." + (TestedObject.context.testedMethod == null ? "<init>" : TestedObject.context.testedMethod.getName());
    }

    public static Class currTestedClazz() {
        if (TestedObject.context.testedClazz == null) {
            throw new RuntimeException("tested class can't be null.");
        }
        return TestedObject.context.testedClazz;
    }

    public static Object currTestedObject() {
        if (TestedObject.context.testedObject == null) {
            throw new RuntimeException("tested object can't be null.");
        }
        return TestedObject.context.testedObject;
    }

    public static Transactional.TransactionMode getTransactionMode() {
        if (TestedObject.context.testedObject == null || TestedObject.context.testedMethod == null) {
            return Transactional.TransactionMode.DISABLED;
        }
        Transactional.TransactionMode transactionMode = AnnotationUtils.getMethodOrClassLevelAnnotationProperty(Transactional.class, "value", Transactional.TransactionMode.DEFAULT, TestedObject.context.testedMethod, TestedObject.context.testedClazz);
        if (transactionMode == Transactional.TransactionMode.DEFAULT) {
            String mode = ConfigurationHelper.getString("transactional.mode.default", "DISABLED");
            transactionMode = Transactional.TransactionMode.valueOf(mode.toUpperCase());
        }
        if (transactionMode == null || transactionMode == Transactional.TransactionMode.DEFAULT) {
            return Transactional.TransactionMode.DISABLED;
        }
        return transactionMode;
    }

    public static boolean isTransactionsEnabled() {
        if (TestedObject.context.testedObject == null || TestedObject.context.testedMethod == null) {
            return false;
        }
        Transactional.TransactionMode mode = TestedObject.getTransactionMode();
        return mode == Transactional.TransactionMode.COMMIT || mode == Transactional.TransactionMode.ROLLBACK;
    }

    public static TransactionManager getLocalTransactionManager() {
        Class testedClazz = TestedObject.currTestedClazz();
        ThreadLocal<TransactionManager> clazzLocal = localTransactionManager.get(testedClazz);
        if (clazzLocal == null) {
            return null;
        }
        TransactionManager transaction = clazzLocal.get();
        return transaction;
    }

    public static void setLocalTransactionManager() {
        Class testedClazz = TestedObject.currTestedClazz();
        TransactionManager transaction = new TransactionManager();
        ThreadLocal<TransactionManager> clazzLocal = new ThreadLocal<TransactionManager>();
        clazzLocal.set(transaction);
        localTransactionManager.put(testedClazz, clazzLocal);
    }

    public static void removeLocalTransactionManager() {
        Class testedClazz = TestedObject.currTestedClazz();
        ThreadLocal<TransactionManager> clazzLocal = localTransactionManager.remove(testedClazz);
        if (clazzLocal == null) {
            return;
        }
        try {
            TransactionManager transactionManager = clazzLocal.get();
            transactionManager.forceEnd();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        clazzLocal.remove();
    }

    public static void setSpringContext(JTesterBeanFactory beanFactory) {
        if (beanFactory == null) {
            JTesterLogger.info("no spring application context for test:" + TestedObject.currTestedClazzName());
            return;
        }
        if (TestedObject.currTestedClazz() == null) {
            throw new RuntimeException("the tested object can't be null.");
        }
        springBeanFactories.put(TestedObject.currTestedClazz(), beanFactory);
    }

    public static JTesterBeanFactory getSpringBeanFactory() {
        if (TestedObject.currTestedClazz() == null) {
            throw new RuntimeException("the tested object can't be null.");
        }
        JTesterBeanFactory beanFactory = springBeanFactories.get(TestedObject.currTestedClazz());
        return beanFactory;
    }

    public static void removeSpringContext() {
        if (TestedObject.currTestedClazz() == null) {
            throw new RuntimeException("the tested object can't be null.");
        }
        SpringBeanCleaner.cleanSpringBeans(TestedObject.context.testedObject);
        JTesterBeanFactory beanFactory = springBeanFactories.remove(TestedObject.currTestedClazz());
        if (beanFactory != null) {
            SpringModuleHelper.closeSpringContext((Object)beanFactory);
        }
    }
}

