/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.context;

import java.lang.reflect.Field;
import org.jtester.bytecode.imposteriser.JTesterProxy;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.bytecode.reflector.MethodAccessor;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.bytecode.reflector.helper.MethodHelper;
import org.jtester.json.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTesterReflector {
    public <T> T invoke(Class clazz, Object target, String method, Object ... paras) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        Class[] paraClazes = MethodHelper.getParameterClazz(paras);
        MethodAccessor methodAccessor = new MethodAccessor(clazz, method, paraClazes);
        Object result = methodAccessor.invokeUnThrow(_target, paras);
        return result;
    }

    public <T> T invoke(Object target, String method, Object ... paras) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        if (target instanceof Class) {
            return this.invokeStatic((Class)target, method, paras);
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        return this.invoke(_target.getClass(), _target, method, paras);
    }

    public <T> T invokeStatic(Class target, String method, Object ... paras) {
        return MethodHelper.invokeStatic(target, method, paras);
    }

    public void setField(Object target, String field, Object value) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        this.setField(_target.getClass(), _target, field, value);
    }

    public void setField(Class clazz, Object target, String field, Object value) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        FieldAccessor accessor = new FieldAccessor(clazz, field);
        accessor.set(_target, value);
    }

    public <T> T getField(Object target, String field) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        return this.getField(_target.getClass(), _target, field);
    }

    public <T> T getField(Class clazz, Object target, String field) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        FieldAccessor accessor = new FieldAccessor(clazz, field);
        return accessor.get(_target);
    }

    public <T> T getStaticField(Class clazz, String field) {
        FieldAccessor accessor = new FieldAccessor(clazz, field);
        Object o = accessor.getStatic();
        return o;
    }

    public void setStaticField(Class clazz, String field, Object value) {
        FieldAccessor accessor = new FieldAccessor(clazz, field);
        accessor.setStatic(value);
    }

    public <T> T getSpringAdvisedTarget(Object source) {
        Object target = ClazzHelper.getProxiedObject(source);
        return (T)target;
    }

    public <T> T newProxy(Class target, String fieldname) {
        if (target == null) {
            throw new RuntimeException("can't get a field from null object.");
        }
        Field field = FieldHelper.getField(target, fieldname);
        Object proxy = JTesterProxy.proxy(target, field);
        return proxy;
    }

    public <T> T newInstance(Class<T> claz) {
        T o = ClazzHelper.newInstance(claz);
        return o;
    }

    public <T> T newInstance(String json) {
        Object o = JSON.toObject(json);
        return o;
    }

    public <T> T newInstance(String json, Class<T> clazz) {
        Object o = JSON.toObject(json, clazz);
        return o;
    }
}

