/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.context;

import javax.sql.DataSource;
import org.jtester.annotations.Transactional;
import org.jtester.core.TestedObject;
import org.jtester.exception.UnConfigDataBaseTypeException;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.utility.JTesterLogger;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionManager {
    private TransactionStatus transactionStatus = null;
    private PlatformTransactionManager transactionManager = null;

    public void startTransaction() {
        try {
            DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
            DataSource dataSource = environment.getDataSource(true);
            DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
            this.setTransaction((PlatformTransactionManager)platformTransactionManager);
        }
        catch (UnConfigDataBaseTypeException e) {
            this.setTransaction(null);
        }
    }

    public void endTransaction() {
        Transactional.TransactionMode mode = TestedObject.getTransactionMode();
        if (mode == null || mode == Transactional.TransactionMode.DISABLED || mode == Transactional.TransactionMode.DEFAULT) {
            return;
        }
        if (mode == Transactional.TransactionMode.COMMIT) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    public void forceEnd() {
        this.commit();
    }

    private void setTransaction(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        if (this.transactionManager != null) {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition(0);
            this.transactionStatus = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() {
        if (this.transactionManager == null) {
            return;
        }
        try {
            JTesterLogger.debug("commit transaction");
            this.transactionManager.commit(this.transactionStatus);
        }
        catch (UnexpectedRollbackException e) {
            StringBuffer message = new StringBuffer();
            message.append("Catch a transaction exception: org.springframework.transaction.UnexpectedRollbackException.\n");
            message.append("\tplease use @Transactional(TransactionMode.DISABLED) on test method.\n");
            message.append("\tException:" + e.getMessage());
            JTesterLogger.warn(message.toString());
        }
        finally {
            this.transactionManager = null;
            this.transactionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback() {
        if (this.transactionManager == null) {
            return;
        }
        try {
            JTesterLogger.debug("Rolling back transaction");
            this.transactionManager.rollback(this.transactionStatus);
        }
        finally {
            this.transactionManager = null;
            this.transactionStatus = null;
        }
    }

    public static final void testIfHasTransactional() {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(DBEnvironmentFactory.getCurrentDBEnvironment().getDataSource(false));
        TransactionStatus status = platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(5));
        platformTransactionManager.commit(status);
    }

    public static final void forceEndTransactional() {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(DBEnvironmentFactory.getCurrentDBEnvironment().getDataSource(false));
        TransactionStatus status = platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(0));
        platformTransactionManager.rollback(status);
    }
}

