/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jtester.core.IJTester;
import org.jtester.core.ListenerExecutor;
import org.jtester.core.TestedObject;
import org.jtester.core.testng.JMockitHookable;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.module.core.JMockitModule;
import org.jtester.module.core.helper.ModulesManager;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestResult;

public abstract class JTesterHookable
implements IHookable,
IJTester {
    protected static final String TEST_CLAZZ_INFO = "%s executing test class[%s] in thread[%d].";
    protected static final String TEST_METHOD_INFO = "%s executing test method[%s . %s ()] in thread[%d].";
    protected Throwable error_setup_class = null;
    protected Throwable error_setup_method = null;
    private Boolean isJMockitEnabled = null;
    private JMockitHookable jmockitHookable = null;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Throwable testedMethodError;
        Throwable beforeRunningError;
        Method testedMethod;
        block5: {
            this.doesMethodHasSetupError();
            testedMethod = testResult.getMethod().getConstructorOrMethod().getMethod();
            beforeRunningError = ListenerExecutor.executeBeforeMethodRunningEvents(this, testedMethod);
            testedMethodError = null;
            try {
                if (beforeRunningError == null) {
                    if (this.jmockitHookable == null) {
                        callBack.runTestMethod(testResult);
                    } else {
                        this.jmockitHookable.run(callBack, testResult);
                    }
                    testedMethodError = this.getTestedMethodError(testResult);
                }
            }
            catch (Throwable e) {
                testedMethodError = this.getTestedMethodError(testResult);
                if (testedMethodError != null) break block5;
                throw TestedObject.getMultipleException(e);
            }
        }
        Throwable afterRunnedError = ListenerExecutor.executeAfterMethodRunnedEvents(this, testedMethod, beforeRunningError != null ? beforeRunningError : testedMethodError);
        this.doesThrowExceptionTeardown(beforeRunningError, testedMethodError, afterRunnedError);
    }

    private void doesMethodHasSetupError() {
        ExceptionWrapper.throwRuntimeException("jtester tested class setup error.", this.error_setup_class);
        ExceptionWrapper.throwRuntimeException("jtester tested method setup error", this.error_setup_method);
    }

    private void doesThrowExceptionTeardown(Throwable beforeRunningError, Throwable testedMethodError, Throwable afterRunnedError) {
        ExceptionWrapper.throwRuntimeException(beforeRunningError);
        Throwable teardowError = testedMethodError != null ? null : afterRunnedError;
        ExceptionWrapper.throwRuntimeException(teardowError);
    }

    private Throwable getTestedMethodError(ITestResult testResult) {
        Throwable testedMethodError = testResult.getThrowable();
        if (testedMethodError != null && testedMethodError instanceof InvocationTargetException) {
            testedMethodError = ((InvocationTargetException)testedMethodError).getTargetException();
        }
        return testedMethodError;
    }

    protected void dealJMockitTestDecorator(ITestContext context) {
        if (this.isJMockitEnabled != null) {
            return;
        }
        this.isJMockitEnabled = ModulesManager.isModuleEnabled(JMockitModule.class);
        if (!this.isJMockitEnabled.booleanValue()) {
            return;
        }
        this.jmockitHookable = new JMockitHookable(context);
    }
}

