/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.internal.MethodInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTesterMethodsOrder
implements IMethodInterceptor {
    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        HashMap map = new HashMap();
        for (IMethodInstance mi : methods) {
            ITestNGMethod method = mi.getMethod();
            Object[] instances = mi.getInstances();
            if (instances == null || instances.length == 0) continue;
            Object instance = instances[0];
            String clazzname = instance.getClass().getName();
            ArrayList<Object> list = (ArrayList<Object>)map.get(clazzname);
            if (list == null) {
                list = new ArrayList<Object>();
                map.put(clazzname, list);
            }
            if (instances.length == 1) {
                list.add(mi);
                continue;
            }
            list.add(new MethodInstance(method, new Object[]{instance}));
        }
        ArrayList<IMethodInstance> order = new ArrayList<IMethodInstance>();
        for (String clazzname : map.keySet()) {
            List list = (List)map.get(clazzname);
            order.addAll(list);
        }
        System.out.println("\n\n\n");
        for (IMethodInstance mi : order) {
            System.out.println(mi.getInstances()[0].getClass().getName());
        }
        System.out.println("\n\n\n");
        return order;
    }
}

