/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jtester.core.testng.TestMethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClazzInfoByGroup {
    private String groupName;
    private Map<String, Set<TestMethodInfo>> methodInfos;

    public TestClazzInfoByGroup(String groupName) {
        this.groupName = groupName;
        this.methodInfos = new HashMap<String, Set<TestMethodInfo>>();
    }

    public Set<TestMethodInfo> getTestMethodInfosByClazzName(String clazzName) {
        Set<TestMethodInfo> testMethodInfo = this.methodInfos.get(clazzName);
        if (testMethodInfo == null) {
            testMethodInfo = new HashSet<TestMethodInfo>();
            this.methodInfos.put(clazzName, testMethodInfo);
        }
        return testMethodInfo;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, Set<TestMethodInfo>> entry : this.methodInfos.entrySet()) {
            buffer.append("clazz " + entry.getKey() + ",Test Method Infos:\n");
            for (TestMethodInfo info : entry.getValue()) {
                buffer.append("\t" + info.toString() + "\n");
            }
        }
        return buffer.toString();
    }

    public int countMethods() {
        int count = 0;
        for (Map.Entry<String, Set<TestMethodInfo>> entry : this.methodInfos.entrySet()) {
            count += entry.getValue().size();
        }
        return count;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String htmlReport() {
        StringBuffer buffer = new StringBuffer();
        boolean isFirstClazz = true;
        int total = this.countMethods();
        buffer.append(String.format("<tr><td rowspan=%d>%s count:%d</td>", total, this.groupName, total));
        for (Map.Entry<String, Set<TestMethodInfo>> clzzInfo : this.methodInfos.entrySet()) {
            if (isFirstClazz) {
                isFirstClazz = false;
            } else {
                buffer.append("<tr>");
            }
            Set<TestMethodInfo> methodInfos = clzzInfo.getValue();
            String clazzName = clzzInfo.getKey();
            buffer.append(String.format("<td rowspan=%d><a title='%s'>%s</a></td>", methodInfos.size(), clazzName, clazzName.replaceAll("[^\\.]+\\.", "")));
            boolean isFirstClazzMethod = true;
            for (TestMethodInfo method : methodInfos) {
                if (isFirstClazzMethod) {
                    isFirstClazzMethod = false;
                } else {
                    buffer.append("<tr>");
                }
                buffer.append(String.format("<td class='%s'>%s</td>", method.getStatus(), method.getMethodName()));
                buffer.append(String.format("<td>%s<td>", method.getGroups().toString()));
                buffer.append("</tr>\n");
            }
        }
        return buffer.toString();
    }
}

