/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng;

import java.util.HashSet;
import java.util.Set;
import org.testng.ITestNGMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestMethodInfo {
    private String status;
    private String clazzName;
    private String methodName;
    private Set<String> groups = new HashSet<String>();
    private String javaDoc;

    TestMethodInfo() {
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestMethodInfo other = (TestMethodInfo)obj;
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }

    public static TestMethodInfo instance(ITestNGMethod testMethod, Set<String> groups, String status) {
        TestMethodInfo methodInfo = new TestMethodInfo();
        methodInfo.clazzName = testMethod.getRealClass().getName();
        methodInfo.methodName = testMethod.getMethodName();
        methodInfo.groups = groups;
        methodInfo.javaDoc = "todo";
        methodInfo.status = status;
        return methodInfo;
    }

    public String toString() {
        return "MethodInfo [clazzName=" + this.clazzName + ", groups=" + this.groups + ", javaDoc=" + this.javaDoc + ", methodName=" + this.methodName + "]";
    }
}

