/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class TestNgUtil {
    private static final Set<Class> NOT_TEST_ANNOTATIONS = new HashSet<Class>(){
        private static final long serialVersionUID = 7752423831360820098L;
        {
            this.add(BeforeSuite.class);
            this.add(BeforeTest.class);
            this.add(BeforeGroups.class);
            this.add(BeforeClass.class);
            this.add(BeforeMethod.class);
            this.add(AfterSuite.class);
            this.add(AfterTest.class);
            this.add(AfterGroups.class);
            this.add(AfterClass.class);
            this.add(AfterMethod.class);
            this.add(DataProvider.class);
            this.add(Factory.class);
        }
    };

    public static boolean run(String clazz, String method, boolean isThrowException) {
        Iterator i$;
        TestNG tng = TestNgUtil.getTestRunner(clazz, method, isThrowException);
        TestListenerAdapter listener = new TestListenerAdapter();
        tng.addListener((ITestListener)listener);
        tng.run();
        int success = listener.getPassedTests().size();
        int failure = listener.getFailedTests().size();
        if (isThrowException && (i$ = listener.getFailedTests().iterator()).hasNext()) {
            ITestResult rt = (ITestResult)i$.next();
            throw new RuntimeException(rt.getThrowable());
        }
        return success == 1 && failure == 0;
    }

    public static TestNG getTestRunner(String clazz, String method, boolean isThrowException) {
        TestNG tng = new TestNG();
        XmlSuite suite = new XmlSuite();
        XmlTest test = new XmlTest(suite);
        test.setName("run testng");
        XmlClass xmlClazz = new XmlClass(clazz);
        try {
            List includes = xmlClazz.getIncludedMethods();
            try {
                Class<?> xmlInclude = Class.forName("org.testng.xml.XmlInclude");
                Constructor<?> constructor = xmlInclude.getConstructor(String.class);
                includes.add(constructor.newInstance(method));
            }
            catch (Throwable e) {
                includes.add(method);
            }
            xmlClazz.getExcludedMethods().add(method + ".+");
        }
        catch (Throwable e) {
            // empty catch block
        }
        test.getXmlClasses().add(xmlClazz);
        ArrayList<XmlSuite> suites = new ArrayList<XmlSuite>();
        suites.add(suite);
        tng.setXmlSuites(suites);
        return tng;
    }

    public static boolean isTestMethod(Class testClass, Method method) {
        boolean methodHasTestAnnotation = method.isAnnotationPresent(Test.class);
        if (methodHasTestAnnotation) {
            return true;
        }
        boolean clazHasTestAnnotation = testClass.isAnnotationPresent(Test.class);
        for (Class superClaz = testClass.getSuperclass(); superClaz != Object.class && !clazHasTestAnnotation; superClaz = superClaz.getSuperclass()) {
            clazHasTestAnnotation = superClaz.isAnnotationPresent(Test.class);
        }
        int modifier = method.getModifiers();
        if (!clazHasTestAnnotation || !Modifier.isPublic(modifier)) {
            return false;
        }
        Annotation[] annotations = method.getDeclaredAnnotations();
        if (annotations == null || annotations.length == 0) {
            return true;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> claz = annotation.annotationType();
            if (!NOT_TEST_ANNOTATIONS.contains(claz)) continue;
            return false;
        }
        return true;
    }
}

