/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtester.core.testng.report.MethodTestDto;
import org.jtester.core.testng.report.ReportPrinter;
import org.jtester.core.testng.report.UserGroupDto;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class UserTestReporter
extends TestListenerAdapter {
    private static final List<MethodTestDto> methods = new ArrayList<MethodTestDto>();
    private static final Map<String, UserGroupDto> userGroups = new HashMap<String, UserGroupDto>();

    public void onTestSuccess(ITestResult result) {
        UserTestReporter.addResult(result, Status.success);
    }

    public void onTestFailure(ITestResult result) {
        UserTestReporter.addResult(result, Status.failure);
    }

    public void onTestSkipped(ITestResult result) {
        UserTestReporter.addResult(result, Status.skipped);
    }

    public void onFinish(ITestContext testContext) {
        ReportPrinter.printHtmlReport(userGroups, methods);
    }

    private static void addResult(ITestResult result, Status status) {
        ITestNGMethod method = result.getMethod();
        if (!method.isTest()) {
            return;
        }
        long duration = result.getEndMillis() - result.getStartMillis();
        String[] groups = method.getGroups();
        String methodName = method.getMethodName();
        String clazzName = method.getRealClass().getName();
        methods.add(new MethodTestDto(methodName, clazzName, status, duration, groups));
        if (groups == null) {
            UserGroupDto userDto = UserTestReporter.getUserGroupDto("ungroup");
            userDto.addResult(status);
            return;
        }
        for (String group : groups) {
            UserGroupDto userDto = UserTestReporter.getUserGroupDto(group);
            userDto.addResult(status);
        }
    }

    private static UserGroupDto getUserGroupDto(String group) {
        UserGroupDto userDto = userGroups.get(group);
        if (userDto == null) {
            userDto = new UserGroupDto(group);
            userGroups.put(group, userDto);
        }
        return userDto;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        success{

            public String css() {
                return "green";
            }
        }
        ,
        failure{

            public String css() {
                return "red";
            }
        }
        ,
        skipped{

            public String css() {
                return "gray";
            }
        };


        public abstract String css();
    }
}

