/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core.testng.report;

import org.jtester.core.testng.UserTestReporter;
import org.jtester.utility.StringHelper;

public class MethodTestDto {
    public static final String UN_GROUP_NAME = "ungroup";
    private String methodName;
    private String clazzName;
    private UserTestReporter.Status status;
    private long duration;
    private String groups;
    private long threadId;

    public MethodTestDto(String methodName, String clazzName, UserTestReporter.Status status, long duration, String[] groups) {
        this.methodName = methodName;
        this.clazzName = clazzName;
        this.status = status;
        this.duration = duration;
        this.groups = groups == null || groups.length == 0 ? UN_GROUP_NAME : StringHelper.join(",", groups);
        this.threadId = Thread.currentThread().getId();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public UserTestReporter.Status getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getGroups() {
        return this.groups;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getSpeedCss() {
        if (this.duration < 10000L) {
            return "green";
        }
        if (10000L <= this.duration && this.duration <= 20000L) {
            return "yellow";
        }
        return "red";
    }
}

