/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.springframework.aop.framework.Advised;

public class ExceptionWrapper {
    public static void throwRuntimeException(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void throwRuntimeException(String error, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        throw new RuntimeException(error, throwable);
    }

    public static RuntimeException wrapdAdvisedException(Object object, Exception e) {
        if (!(object instanceof Advised)) {
            return new RuntimeException(e);
        }
        Advised advised = (Advised)object;
        StringBuilder sb = new StringBuilder();
        sb.append("value[" + object + "] is org.springframework.aop.framework.Advised\n");
        if (advised.isProxyTargetClass()) {
            sb.append("proxied by the full target class");
            return new RuntimeException(sb.toString(), e);
        }
        Class[] clazzes = ((Advised)object).getProxiedInterfaces();
        sb.append("proxyed by the interfaces:\n");
        for (Class clazz : clazzes) {
            sb.append("\t" + clazz.getName() + "\n");
        }
        return new RuntimeException(sb.toString(), e);
    }

    public static RuntimeException getUndeclaredThrowableExceptionCaused(Throwable e) {
        if (!(e instanceof UndeclaredThrowableException)) {
            return ExceptionWrapper.wrapWithRuntimeException(e);
        }
        Throwable e1 = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
        if (!(e1 instanceof InvocationTargetException)) {
            return ExceptionWrapper.wrapWithRuntimeException(e1);
        }
        Throwable e2 = ((InvocationTargetException)e1).getTargetException();
        return ExceptionWrapper.wrapWithRuntimeException(e2);
    }

    public static RuntimeException wrapWithRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static String toString(Throwable e) {
        if (e == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

