/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.exception;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleException
extends RuntimeException {
    private static final long serialVersionUID = 7060749249322672700L;
    private StringBuffer message = new StringBuffer();

    public MultipleException() {
    }

    public MultipleException(String message, Throwable cause) {
        super(message, cause);
    }

    public MultipleException(String message) {
        super(message);
    }

    public MultipleException(Throwable cause) {
        super(cause);
    }

    public MultipleException(Throwable cause, Throwable ... more) {
        super(cause);
        for (Throwable item : more) {
            this.addException(item);
        }
    }

    public MultipleException(String message, Throwable cause, Throwable ... more) {
        super(message, cause);
        for (Throwable item : more) {
            this.addException(item);
        }
    }

    public void addException(Throwable e) {
        for (Throwable caused = e; caused != null; caused = caused.getCause()) {
            this.message.append("\n").append(e.getClass().getName()).append(": ").append(e.getLocalizedMessage());
        }
    }

    public void addException(List<Throwable> list) {
        for (Throwable item : list) {
            this.addException(item);
        }
    }

    @Override
    public String getMessage() {
        return super.getMessage() + this.message.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return super.getLocalizedMessage() + this.message.toString();
    }

    public static MultipleException getMultipleException(Throwable ... more) {
        Throwable caused = null;
        for (Throwable item : more) {
            if (item == null) continue;
            caused = item;
            break;
        }
        if (caused == null) {
            return null;
        }
        MultipleException exception = new MultipleException(caused);
        for (Throwable item : more) {
            exception.addException(item);
        }
        return exception;
    }
}

