/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.jtester.fit.WikiFile;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

public class ErrorRecorder {
    static final String FIT_WRONG_MESSAGE_HTML = System.getProperty("user.dir") + "/target/dbfit/fitnesse.wrong.html";
    private static final String NO_FAILURE = "<div class='pass'>no failure</div>";
    private static boolean HAS_ADD_ERROR = false;

    public static void createNewErrorFile() {
        try {
            File file = new File(FIT_WRONG_MESSAGE_HTML);
            ResourceHelper.mkFileParentDir(file);
            FileWriter writer = new FileWriter(file, false);
            writer.write("<html><style>");
            writer.write(ResourceHelper.readFromFile("org/jtester/fit/fitnesse_base.css"));
            writer.write("</style><body>");
            ((Writer)writer).close();
        }
        catch (Throwable e1) {
            throw new RuntimeException(e1);
        }
    }

    public static void addError(WikiFile wiki, String html, Exception e) {
        HAS_ADD_ERROR = true;
        StringBuilder buffer = new StringBuilder();
        String exception = StringHelper.exceptionTrace(e, StringHelper.DEFAULT_EXCEPTION_FILTER);
        buffer.append("<br/><br/><div>============" + wiki.getWikiUrl() + "==============</div></br>");
        buffer.append("<table  border='1' cellspacing='0'>");
        buffer.append("<tr><td class='error'><div class='fit_stacktrace'>" + exception + "</div></td></tr>");
        buffer.append("</table><br/>");
        int start = html.indexOf("<table");
        int end = html.length() - 8;
        String content = html.substring(start, end).trim();
        buffer.append(content);
        try {
            File htmlFile = new File(FIT_WRONG_MESSAGE_HTML);
            if (!htmlFile.exists()) {
                ErrorRecorder.createNewErrorFile();
            }
            FileWriter writer = new FileWriter(htmlFile, true);
            writer.write(buffer.toString());
            ((Writer)writer).close();
        }
        catch (Throwable e1) {
            throw new RuntimeException(e1);
        }
    }

    public static void endAddError() {
        try {
            File file = new File(FIT_WRONG_MESSAGE_HTML);
            String header = "";
            if (!file.exists()) {
                ResourceHelper.mkFileParentDir(file);
                header = String.format("<html><style>%s</style><body>", "org/jtester/fit/fitnesse_base.css");
            }
            FileWriter writer = new FileWriter(file, true);
            writer.write(header);
            if (!HAS_ADD_ERROR) {
                writer.write(NO_FAILURE);
            }
            writer.write("</body></html>");
            ((Writer)writer).close();
        }
        catch (Throwable e1) {
            throw new RuntimeException(e1);
        }
    }
}

