/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit;

import fit.Counts;
import fitlibrary.batch.trinidad.InMemoryTestImpl;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.batch.trinidad.TestEngine;
import fitlibrary.batch.trinidad.TestResult;
import fitlibrary.runner.SpreadsheetRunner;
import fitlibrary.suite.BatchFitLibrary;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.jtester.exception.FitRunException;
import org.jtester.fit.ErrorRecorder;
import org.jtester.fit.JTesterFitLibraryTestEngine;
import org.jtester.fit.WikiFile;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.dbfit.DbFitWikiPage;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitRunner {
    protected final TestEngine testRunner = new JTesterFitLibraryTestEngine();
    protected final String fitDir;
    protected String rootPath = null;
    private static final String ERR_MESSAGE = "Run Wiki Page[%s.wiki],right=%d; wrong=%d;exceptions=%d.\nclass path url[%s].\nResult['file://%s']";
    private static final String CSS_FILE = "<link rel='stylesheet' media='all' type='text/css' href='file:///%s/fitnesse.css' />";
    public static final String Fitnesse_Css_Resource_Path = "org/jtester/fit/fitnesse_base.css";
    private static FitRunner fitRunner = new FitRunner();

    protected FitRunner() {
        this(ConfigurationHelper.dbfitDir());
    }

    protected FitRunner(String fitDir) {
        this.fitDir = fitDir;
        this.prepareFiles();
    }

    protected void runFitTest(Class claz, String url) throws Exception {
        if (StringHelper.isBlankOrNull(url)) {
            return;
        }
        if (!WikiFile.isFitFile(url)) {
            throw new RuntimeException(String.format("url:%s is not a valid fit file name", url));
        }
        WikiFile wiki = WikiFile.findWikiFile(claz, url);
        this.runFitnesseWiki(wiki.wikiName(), wiki);
    }

    void runFitExcel(Class claz, String url) {
        SpreadsheetRunner runner = new SpreadsheetRunner();
        try {
            runner.run(new File(url), new File("report.html"), new BatchFitLibrary());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void runFitnesseWiki(String name, WikiFile wikiFile) throws FileNotFoundException {
        String wiki = wikiFile.readWikiContent();
        wiki = this.decoratedWiki(wiki);
        String html = this.addCssFile(DbFitWikiPage.getHtml(wiki));
        InMemoryTestImpl test = new InMemoryTestImpl(name, html);
        TestResult testResult = this.testRunner.runTest((TestDescriptor)test);
        File htmlFile = wikiFile.mkTestedDir(this.fitDir);
        System.err.println(testResult.getName() + " right:" + testResult.getCounts().right + " wrong:" + testResult.getCounts().wrong + " exeptions: " + testResult.getCounts().exceptions);
        String resultHtml = testResult.getContent();
        ResourceHelper.writeStringToFile(htmlFile, resultHtml);
        try {
            this.isSuccess(testResult, name, wikiFile);
        }
        catch (FitRunException e) {
            ErrorRecorder.addError(wikiFile, resultHtml, e);
            throw new RuntimeException(e);
        }
    }

    protected String decoratedWiki(String wiki) {
        return wiki;
    }

    private void isSuccess(TestResult tr, String name, WikiFile wikiFile) throws FitRunException {
        Counts count = tr.getCounts();
        int right = count.right;
        int wrong = count.wrong;
        int exception = count.exceptions;
        if (wrong + exception != 0) {
            throw new FitRunException(String.format(ERR_MESSAGE, name, right, wrong, exception, wikiFile.getWikiUrl(), wikiFile.getHtmlFilePath()));
        }
    }

    private String addCssFile(String html) {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("\n");
        buffer.append(String.format(CSS_FILE, this.rootPath));
        buffer.append("\n");
        buffer.append(html);
        buffer.append("\n");
        buffer.append("</html>");
        return buffer.toString();
    }

    void prepareFiles() {
        File folder = new File(this.fitDir + File.separatorChar + "files");
        File css = new File(this.fitDir + File.separatorChar + "files/fitnesse.css");
        ResourceHelper.mkFileParentDir(css);
        this.rootPath = folder.getAbsolutePath();
        if (!css.exists()) {
            ResourceHelper.copyClassPathResource(Fitnesse_Css_Resource_Path, css);
        }
    }

    String getFitDir() {
        return this.fitDir;
    }

    public static void runFit(Class claz, String url, String ... urls) {
        try {
            fitRunner.runFitTest(claz, url);
            for (String wiki : urls) {
                fitRunner.runFitTest(claz, wiki);
            }
        }
        catch (Throwable e) {
            throw new FitRunException(e);
        }
    }

    public static void runFit(Class claz, boolean cleanSymbols, String url, String ... urls) {
        FitRunner.runFit(claz, url, urls);
        if (cleanSymbols) {
            SymbolUtil.cleanSymbols();
        }
    }

    public static void runFit(Class claz, Map<String, ?> symbols, String url, String ... urls) {
        SymbolUtil.setSymbol(symbols);
        FitRunner.runFit(claz, url, urls);
    }

    public static void runFit(Class claz, Map<String, ?> symbols, boolean cleanSymbols, String url, String ... urls) {
        SymbolUtil.setSymbol(symbols);
        FitRunner.runFit(claz, url, urls);
        if (cleanSymbols) {
            SymbolUtil.cleanSymbols();
        }
    }
}

