/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit;

import java.io.File;
import java.io.FileNotFoundException;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

public class WikiFile {
    private static final String FIT_SURFIX = ".wiki";
    private String wikiName;
    private String wikiUrl;
    private String htmlFilePath = null;

    public static boolean isFitFile(String filename) {
        if (StringHelper.isBlankOrNull(filename)) {
            return false;
        }
        if (!(filename = filename.trim()).endsWith(FIT_SURFIX)) {
            return false;
        }
        return filename.length() > FIT_SURFIX.length();
    }

    public File mkTestedDir(String dbfitDir) {
        int last = this.wikiUrl.lastIndexOf(FIT_SURFIX);
        String base = System.getProperty("user.dir");
        this.htmlFilePath = String.format("%s/%s/%s.html", base, dbfitDir, this.wikiUrl.subSequence(0, last));
        File html = new File(this.htmlFilePath);
        ResourceHelper.mkFileParentDir(html);
        return html;
    }

    public String readWikiContent() throws FileNotFoundException {
        String content = ResourceHelper.readFromFile(this.wikiUrl);
        return content;
    }

    public static WikiFile findWikiFile(Class claz, String url) throws Exception {
        WikiFile wikiFile = new WikiFile();
        wikiFile.wikiName = url.replaceAll(".*[\\/\\\\]", "").replaceFirst(FIT_SURFIX, "");
        if (claz != null && ResourceHelper.isResourceExists(claz, url)) {
            wikiFile.wikiUrl = ClazzHelper.getPathFromPath(claz) + "/" + url;
        } else if (ResourceHelper.isResourceExists(null, url)) {
            wikiFile.wikiUrl = url;
        } else {
            if (claz == null) {
                throw new RuntimeException(String.format("can't find wiki in classpath:%s", url));
            }
            throw new RuntimeException(String.format("can't find wiki in classpaths:%s and %s", ClazzHelper.getPathFromPath(claz) + "/" + url, url));
        }
        return wikiFile;
    }

    public String getHtmlFilePath() {
        return this.htmlFilePath;
    }

    public String wikiName() {
        return this.wikiName;
    }

    public String getWikiUrl() {
        return this.wikiUrl;
    }
}

