/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit.fixture;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.fit.fixture.SpringFixture;
import org.jtester.fit.util.ParseArg;

public class DtoCheckFixture
extends SpringFixture {
    private static ThreadLocal<Map<String, Object>> localDto = new ThreadLocal();
    private String[] bindings;
    Object dto;
    String storekey;
    int index;
    Parse currentRow = null;

    public void doRows(Parse rows) {
        if (rows == null || rows.parts == null) {
            throw new FitFailureException("You must specify identified name of stored dto.");
        }
        this.dto = this.findDto(rows.parts);
        this.index = 0;
        Parse rest = rows.more;
        if (rest == null || rest.parts == null) {
            throw new RuntimeException("You must specify checked proproties!");
        }
        this.bindDtoProperties(rest.parts);
        this.currentRow = rest;
        super.doRows(rest.more);
        this.addSurplusRows();
    }

    private void addSurplusRows() {
        if (this.currentRow == null) {
            return;
        }
        if (this.dto instanceof List) {
            List list = (List)this.dto;
            for (int loop = this.index; loop < list.size(); ++loop) {
                Object moreObject = list.get(loop);
                this.addSurplusRow(moreObject);
            }
        } else if (this.index == 0) {
            this.addSurplusRow(this.dto);
        }
    }

    private void addSurplusRow(Object obj) {
        Parse newRow;
        this.currentRow.more = newRow = new Parse("tr", null, null, null);
        this.currentRow = newRow;
        try {
            Parse firstCell;
            String value = DtoCheckFixture.getValueFrom(obj, this.bindings[0]);
            newRow.parts = firstCell = new Parse("td", value, null, null);
            firstCell.addToBody(Fixture.gray((String)" surplus"));
            this.wrong(firstCell);
            for (int i = 1; i < this.bindings.length; ++i) {
                Parse nextCell;
                firstCell.more = nextCell = new Parse("td", DtoCheckFixture.getValueFrom(obj, this.bindings[i]), null, null);
                firstCell = nextCell;
            }
        }
        catch (Throwable e) {
            this.exception(newRow, e);
        }
    }

    public void doRow(Parse row) {
        this.currentRow = row;
        Parse cells = row.parts;
        try {
            Object expected = this.getObjectByIndex();
            ++this.index;
            for (int i = 0; cells != null && i < this.bindings.length; ++i) {
                String binding = this.bindings[i];
                String text = ParseArg.parseCellValue(cells);
                String value = DtoCheckFixture.getValueFrom(expected, binding);
                if (!(text == null && value == null || text != null && text.equals(value))) {
                    String message = String.format("expected value %s,but actual value is %s", text, value);
                    this.exception(cells, new RuntimeException(message));
                    return;
                }
                this.right(cells);
                cells = cells.more;
            }
        }
        catch (Throwable e) {
            this.exception(cells, e);
        }
    }

    private Object getObjectByIndex() {
        if (this.dto == null) {
            if (this.index == 0) {
                return null;
            }
            throw new RuntimeException("no more expected data, actual data size is null");
        }
        if (this.dto instanceof List) {
            List list = (List)this.dto;
            if (this.index < list.size()) {
                return ((List)this.dto).get(this.index);
            }
            throw new RuntimeException("no more expected data, actual data size is:" + list.size());
        }
        return this.dto;
    }

    public static void storeDto(String name, Object dto) {
        String key = DtoCheckFixture.camel((String)name);
        Map<String, Object> map = localDto.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, Object>();
            localDto.set(map);
        }
        ArrayList store = dto;
        if (dto instanceof Collection && !(dto instanceof List)) {
            store = new ArrayList(dto);
        } else if (dto instanceof Object[]) {
            Object[] os;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : os = (Object[])dto) {
                list.add(o);
            }
            store = list;
        }
        map.put(key, store);
    }

    public static void removeDto(String name) {
        Map<String, Object> map = localDto.get();
        if (map != null) {
            map.remove(name);
        }
    }

    private Object findDto(Parse dtoParse) {
        String storekey = DtoCheckFixture.camel((String)dtoParse.text());
        Map<String, Object> maps = localDto.get();
        if (maps == null || !maps.containsKey(storekey)) {
            throw new RuntimeException("can't find stored data for key[" + storekey + "]");
        }
        this.right(dtoParse);
        return maps.get(storekey);
    }

    private void bindDtoProperties(Parse dtoProps) {
        int size = dtoProps.size();
        try {
            this.bindings = new String[size];
            int i = 0;
            while (dtoProps != null) {
                String property;
                this.bindings[i] = property = DtoCheckFixture.camel((String)dtoProps.text());
                ++i;
                dtoProps = dtoProps.more;
            }
        }
        catch (Throwable e) {
            this.wrong(dtoProps);
            throw new RuntimeException(e);
        }
    }

    private static String getValueFrom(Object expected, String field) {
        if (expected == null) {
            return null;
        }
        Object value = null;
        if (expected instanceof Map) {
            value = ((Map)expected).get(field);
        } else {
            FieldAccessor accessor = new FieldAccessor(expected, field);
            value = accessor.get(expected);
        }
        if (value == null) {
            return "<null>";
        }
        return value.toString();
    }
}

