/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit.fixture;

import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.FitFailureException;
import java.util.List;
import java.util.Map;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.bytecode.reflector.MethodAccessor;
import org.jtester.bytecode.reflector.helper.MethodHelper;
import org.jtester.exception.NoSuchMethodRuntimeException;
import org.jtester.fit.fixture.SpringFixture;
import org.jtester.fit.util.ParseArg;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtoPropertyFixture
extends SpringFixture {
    private Class dtoClazz;
    private MethodAccessor accessor;
    private PropertyBinding[] bindings;
    private String parsePropertyMethodName;

    public void doRows(Parse rows) {
        Parse first = rows.parts;
        if (first == null) {
            throw new FitFailureException("You must specify a method.");
        }
        this.findMethod(first);
        Parse rest = rows.more;
        if (rest == null || rest.parts == null) {
            throw new RuntimeException("No test case is found!");
        }
        this.bindDtoProperties(rest.parts);
        super.doRows(rest.more);
    }

    protected void findMethod(Parse cell) {
        String methodname = cell.text();
        methodname = StringHelper.camel(methodname);
        Parse argument = cell.more;
        if (StringHelper.isBlankOrNull(methodname)) {
            throw new FitFailureException("You must specify a method.");
        }
        try {
            if (argument == null) {
                this.accessor = MethodHelper.findMethodByArgCount(this, methodname, 1);
                this.dtoClazz = this.accessor.getMethod().getParameterTypes()[0];
            } else {
                String clazzName = argument.text();
                this.dtoClazz = Class.forName(clazzName);
                this.accessor = new MethodAccessor(this, methodname, this.dtoClazz);
            }
            this.right(cell);
        }
        catch (Throwable e) {
            this.wrong(cell);
            throw new RuntimeException(e);
        }
    }

    private void bindDtoProperties(Parse dtoProps) {
        int size = dtoProps.size();
        try {
            String prop = dtoProps.text().trim();
            if (size == 1 && prop.startsWith(">>")) {
                this.parsePropertyMethodName = DtoPropertyFixture.camel((String)("parse " + prop.substring(2)));
                this.bindings = null;
            } else {
                this.parsePropertyMethodName = null;
                this.bindings = new PropertyBinding[size];
                int i = 0;
                while (dtoProps != null) {
                    String property = DtoPropertyFixture.camel((String)dtoProps.text());
                    this.bindings[i] = new PropertyBinding(property);
                    ++i;
                    dtoProps = dtoProps.more;
                }
            }
        }
        catch (Throwable e) {
            this.wrong(dtoProps);
            throw new RuntimeException(e);
        }
    }

    public void doRow(Parse row) {
        Parse cells = row.parts;
        try {
            Object para = this.instancePara(cells);
            Object result = this.accessor.invoke(this, new Object[]{para});
            if (!(result instanceof Boolean)) {
                this.right(cells);
            } else if (((Boolean)result).booleanValue()) {
                this.right(cells);
            } else {
                this.wrong(cells);
            }
        }
        catch (Throwable e) {
            this.exception(cells, e);
        }
    }

    private Object instancePara(Parse cells) throws Exception {
        if (this.parsePropertyMethodName != null) {
            String text = cells.text();
            try {
                MethodAccessor methodAccessor = new MethodAccessor(this, this.parsePropertyMethodName, String.class);
                return methodAccessor.invoke(this, new Object[]{text});
            }
            catch (NoSuchMethodRuntimeException e) {
                TypeAdapter typeAdapter = TypeAdapter.on((Fixture)this, (Class)this.dtoClazz);
                return typeAdapter.parse(text);
            }
        }
        Object obj = this.dtoClazz.newInstance();
        for (int i = 0; cells != null && i < this.bindings.length; ++i) {
            PropertyBinding binding = this.bindings[i];
            String text = ParseArg.parseCellValue(cells);
            binding.setValue(obj, text);
            cells = cells.more;
        }
        return obj;
    }

    protected static List<String> parseList(String value) {
        return ParseArg.parseList(value);
    }

    protected static List<String> parseList(String value, String split) {
        return ParseArg.parseList(value, split);
    }

    protected static Map<String, String> parseMap(String value) {
        return ParseArg.parseMap(value);
    }

    protected static Map<String, String> parseMap(String value, String entrySplit, String keySplit) {
        return ParseArg.parseMap(value, entrySplit, keySplit);
    }

    protected static <T> T paserJson(Class<T> clazz, String json) {
        return ParseArg.paserJson(clazz, json);
    }

    protected class PropertyBinding {
        private FieldAccessor fieldAccessor;
        private String parseMethodName;
        private TypeAdapter typeAdapter;

        public PropertyBinding(String property) throws Exception {
            this.fieldAccessor = new FieldAccessor(DtoPropertyFixture.this.dtoClazz, Fixture.camel((String)property));
            this.parseMethodName = Fixture.camel((String)("parse " + property));
            this.typeAdapter = TypeAdapter.on((Fixture)DtoPropertyFixture.this, (Class)this.fieldAccessor.getFieldType());
        }

        public void setValue(Object obj, String value) throws Exception {
            try {
                MethodAccessor methodAccessor = new MethodAccessor(obj, this.parseMethodName, String.class);
                methodAccessor.invoke(obj, new Object[]{value});
            }
            catch (NoSuchMethodRuntimeException e) {
                Object _value = this.typeAdapter.parse(value);
                this.fieldAccessor.set(obj, _value);
            }
        }
    }
}

