/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit.spring;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.jtester.annotations.SpringBeanByName;
import org.jtester.annotations.SpringBeanByType;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.StringHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixtureBeanInjector {
    final ApplicationContext ctx;
    final Object testedObject;
    final Class testedClazz;

    public FixtureBeanInjector(ApplicationContext ctx, Object testedObject) {
        this.ctx = ctx;
        this.testedObject = testedObject;
        if (testedObject == null) {
            throw new RuntimeException("tested object can't be null!");
        }
        this.testedClazz = testedObject.getClass();
    }

    public static void injectBeans(ApplicationContext ctx, Object testedObject) {
        FixtureBeanInjector injector = new FixtureBeanInjector(ctx, testedObject);
        injector.injectBeans();
    }

    public void injectBeans() {
        FixtureBeanInjector.injectSpringBeanByName(this.ctx, this.testedClazz, this.testedObject);
        FixtureBeanInjector.injectSpringBeanByType(this.ctx, this.testedClazz, this.testedObject);
    }

    public static void injectSpringBeanByName(ApplicationContext ctx, Class testedClazz, Object testedObject) {
        Set<Field> springBeanByNamefields = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, SpringBeanByName.class);
        for (Field field : springBeanByNamefields) {
            try {
                SpringBeanByName byName = field.getAnnotation(SpringBeanByName.class);
                String beanName = field.getName();
                if (!StringHelper.isBlankOrNull(byName.value())) {
                    beanName = byName.value();
                }
                FieldHelper.setFieldValue(testedObject, field, ctx.getBean(beanName));
            }
            catch (Throwable e) {
                throw new JTesterException("Unable to assign the Spring bean value to field annotated with @SpringBeanByName", e);
            }
        }
    }

    public static void injectSpringBeanByType(ApplicationContext ctx, Class testedClazz, Object testedObject) {
        Set<Field> springBeanByTypeFields = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, SpringBeanByType.class);
        for (Field field : springBeanByTypeFields) {
            try {
                FieldHelper.setFieldValue(testedObject, field, FixtureBeanInjector.getSpringBeanByType(ctx, field.getType()));
            }
            catch (Throwable e) {
                throw new JTesterException("Unable to assign the Spring bean value to field annotated with @SpringBeanByType", e);
            }
        }
    }

    private static <T> T getSpringBeanByType(ApplicationContext ctx, Class<T> type) {
        Map beans = ctx.getBeansOfType(type);
        if (beans == null || beans.size() == 0) {
            throw new JTesterException("Unable to get Spring bean by type. No Spring bean found for type " + type.getSimpleName());
        }
        if (beans.size() > 1) {
            throw new JTesterException("Unable to get Spring bean by type. More than one possible Spring bean for type " + type.getSimpleName() + ". Possible beans; " + beans);
        }
        return (T)beans.values().iterator().next();
    }
}

