/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit.spring;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jtester.annotations.SpringBeanRemote;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.remoting.caucho.HessianServiceExporter;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;

public class RemoteInvokerRegister {
    private static final String SPRINGBEAN_REMOTE_BASEURL = "${springbean.remote.baseurl}";

    public static void registerSpringBeanRemoteOnClient(DefaultListableBeanFactory beanFactory, Class testedClazz) {
        Set<Field> fields_HttpInvoker = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, SpringBeanRemote.class);
        for (Field field : fields_HttpInvoker) {
            Class<?> serviceInterface;
            SpringBeanRemote.SpringBeanRemoteType type;
            SpringBeanRemote springBeanRemote = field.getAnnotation(SpringBeanRemote.class);
            String beanID = springBeanRemote.value();
            if (StringHelper.isBlankOrNull(beanID)) {
                beanID = field.getName();
            }
            if ((type = SpringBeanRemote.SpringBeanRemoteType.getTypeFromURL(beanID)) == null) {
                type = springBeanRemote.type();
                beanID = type.name() + "/" + beanID;
            }
            if (beanFactory.containsBeanDefinition(beanID)) {
                JTesterLogger.info(String.format("spring bean[%s] has been defined in application context!", beanID));
                return;
            }
            String serviceUrl = springBeanRemote.serviceUrl();
            if (StringHelper.isBlankOrNull(serviceUrl)) {
                serviceUrl = "${springbean.remote.baseurl}/" + beanID;
            }
            if ((serviceInterface = springBeanRemote.serviceInterface()) == null || serviceInterface == Object.class) {
                serviceInterface = field.getType();
            }
            RootBeanDefinition beanDefinition = RemoteInvokerRegister.newClientRemoteInvokerBeanDefinition(beanID, serviceUrl, serviceInterface, type);
            beanFactory.registerBeanDefinition(beanID, (BeanDefinition)beanDefinition);
        }
    }

    public static void injectSpringBeanRemote(ApplicationContext ctx, Object testedObject) {
        Set<Field> fields_HttpInvoker = AnnotationUtils.getFieldsAnnotatedWith(testedObject.getClass(), SpringBeanRemote.class);
        for (Field field : fields_HttpInvoker) {
            SpringBeanRemote.SpringBeanRemoteType type;
            SpringBeanRemote springBeanRemote = field.getAnnotation(SpringBeanRemote.class);
            String beanID = springBeanRemote.value();
            if (StringHelper.isBlankOrNull(beanID)) {
                beanID = field.getName();
            }
            if ((type = SpringBeanRemote.SpringBeanRemoteType.getTypeFromURL(beanID)) == null) {
                type = springBeanRemote.type();
                beanID = type.name() + "/" + beanID;
            }
            try {
                Object bean = ctx.getBean(beanID);
                FieldHelper.setFieldValue(testedObject, field, bean);
            }
            catch (Throwable e) {
                throw new JTesterException("Unable to assign the Spring http invoker bean to field annotated with @HttpInvoker", e);
            }
        }
    }

    private static RootBeanDefinition newClientRemoteInvokerBeanDefinition(String beanID, final String serviceUrl, final Class serviceInterface, SpringBeanRemote.SpringBeanRemoteType type) {
        if (!serviceInterface.isInterface()) {
            String error = String.format("httpInvoker[%s] service interface must be an interface, but actual is:%s", beanID, serviceInterface.getName());
            throw new RuntimeException(error);
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        if (type == SpringBeanRemote.SpringBeanRemoteType.httpinvoker) {
            beanDefinition.setBeanClassName("org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean");
        } else if (type == SpringBeanRemote.SpringBeanRemoteType.hessian) {
            beanDefinition.setBeanClassName("org.springframework.remoting.caucho.HessianProxyFactoryBean");
        } else {
            throw new RuntimeException("unsupport remote inovker bype:" + (Object)((Object)type));
        }
        beanDefinition.setScope("singleton");
        beanDefinition.setAutowireCandidate(true);
        MutablePropertyValues properties = new MutablePropertyValues((Map)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("serviceUrl", serviceUrl);
                this.put("serviceInterface", serviceInterface.getName());
            }
        });
        beanDefinition.setPropertyValues(properties);
        beanDefinition.setAutowireMode(1);
        return beanDefinition;
    }

    public static void registerSpringBeanRemoteOnServer(Properties properties, DefaultListableBeanFactory beanFactory) {
        Enumeration<Object> en = properties.keys();
        while (en.hasMoreElements()) {
            String bean = (String)en.nextElement();
            String claz = properties.getProperty(bean);
            int start = claz.indexOf("<");
            String[] types = new String[]{"hessian"};
            if (start > 0 && claz.endsWith(">")) {
                types = claz.substring(start + 1, claz.length() - 1).split("\\|");
                claz = claz.substring(0, start);
            }
            if (types == null || types.length == 0) {
                types = new String[]{"hessian"};
            }
            for (String type : types) {
                RootBeanDefinition beanDefinition;
                if (type == null) continue;
                if ((type = type.trim()).equalsIgnoreCase("httpinvoker")) {
                    beanDefinition = RemoteInvokerRegister.newServerRemoteInvokerBeanDefinition(bean, claz, HttpInvokerServiceExporter.class.getName());
                    beanFactory.registerBeanDefinition("/httpinvoker/" + bean, (BeanDefinition)beanDefinition);
                    JTesterLogger.info("register httpinvoker bean[/httpinvoker/" + bean + "] successfully.");
                    continue;
                }
                if (type.equalsIgnoreCase("hessian")) {
                    beanDefinition = RemoteInvokerRegister.newServerRemoteInvokerBeanDefinition(bean, claz, HessianServiceExporter.class.getName());
                    beanFactory.registerBeanDefinition("/hessian/" + bean, (BeanDefinition)beanDefinition);
                    JTesterLogger.info("register httpinvoker bean[/hessian/" + bean + "] successfully.");
                    continue;
                }
                throw new RuntimeException(String.format("unsupport remote invoker type[%s], only support hessian or httpinvoker.", type));
            }
        }
    }

    private static RootBeanDefinition newServerRemoteInvokerBeanDefinition(final String beanID, final String serviceInterface, String invokerExporterClazz) {
        if (StringHelper.isBlankOrNull(beanID) || StringHelper.isBlankOrNull(serviceInterface)) {
            throw new RuntimeException("illegal properties file[classpath:jtester-remote.properties].");
        }
        try {
            Class<?> claz = Class.forName(serviceInterface);
            if (!claz.isInterface()) {
                String error = String.format("httpInvoker[%s] service interface must be an interface, but actual is:%s", beanID, serviceInterface);
                throw new RuntimeException(error);
            }
        }
        catch (ClassNotFoundException e) {
            String error = String.format("define bean[%s] error.", invokerExporterClazz);
            throw new RuntimeException(error, e);
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClassName(invokerExporterClazz);
        beanDefinition.setScope("singleton");
        beanDefinition.setAutowireCandidate(true);
        MutablePropertyValues properties = new MutablePropertyValues((Map)new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("service", new RuntimeBeanReference(beanID));
                this.put("serviceInterface", serviceInterface);
            }
        });
        beanDefinition.setPropertyValues(properties);
        beanDefinition.setAutowireMode(1);
        return beanDefinition;
    }
}

