/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit.util;

import fit.Fixture;
import fit.Parse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.json.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseArg {
    public static String SYMBOL_PATTERN_EXPRESSION = "@\\{([\\w\\-\\.]+)\\}";
    private static Pattern symbolPattern = Pattern.compile(SYMBOL_PATTERN_EXPRESSION);

    public static <T> T paserJson(Class<T> clazz, String json) {
        return JSON.toObject(json, clazz);
    }

    public static Map<String, String> parseMap(String value, String entrySplit, String keySplit) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        if (value == null || value.equalsIgnoreCase("null")) {
            return null;
        }
        if (value.trim().equalsIgnoreCase("")) {
            return map;
        }
        for (String pair : pairs = value.split(entrySplit)) {
            String[] entry = pair.split(keySplit);
            map.put(entry[0], entry[1]);
        }
        return map;
    }

    public static Map<String, String> parseMap(String value) {
        return ParseArg.parseMap(value, ";", ":");
    }

    public static List<String> parseList(String value, String split) {
        String[] items;
        ArrayList<String> list = new ArrayList<String>();
        if (value == null || value.equalsIgnoreCase("null")) {
            return null;
        }
        if (value.trim().equalsIgnoreCase("")) {
            return list;
        }
        for (String item : items = value.split(split)) {
            list.add(item);
        }
        return list;
    }

    public static List<String> parseList(String value) {
        return ParseArg.parseList(value, ";");
    }

    public static boolean containSymbols(String text) {
        return text.matches(".*" + SYMBOL_PATTERN_EXPRESSION + ".*");
    }

    public static String exactCellSymbolText(String text) {
        String[] symbols;
        String _text = text;
        for (String symbol : symbols = ParseArg.extractParamNames(text)) {
            String value = (String)SymbolUtil.getSymbol(symbol);
            if (value == null) continue;
            _text = _text.replaceFirst("@\\{" + symbol + "\\}", value);
        }
        return _text;
    }

    public static String[] extractParamNames(String commandText) {
        ArrayList<String> hs = new ArrayList<String>();
        Matcher mc = symbolPattern.matcher(commandText);
        while (mc.find()) {
            hs.add(mc.group(1));
        }
        String[] array = new String[hs.size()];
        return hs.toArray(array);
    }

    public static String parseCellValue(Parse cell) {
        String content = cell.text();
        if (content.startsWith("<<")) {
            String value = (String)SymbolUtil.getSymbol(content.substring(2));
            cell.addToBody(Fixture.gray((String)("= " + value)));
            return value;
        }
        if (ParseArg.containSymbols(content)) {
            String value = ParseArg.exactCellSymbolText(content);
            cell.addToBody(Fixture.gray((String)("= " + String.valueOf(value))));
            return value;
        }
        return content;
    }

    public static String parseCellValue(String text) {
        if (text == null) {
            return "<null>";
        }
        if (text.startsWith("<<")) {
            String value = (String)SymbolUtil.getSymbol(text.substring(2));
            return value;
        }
        if (ParseArg.containSymbols(text)) {
            String value = ParseArg.exactCellSymbolText(text);
            return value;
        }
        return text;
    }
}

