/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.fit.util;

import fit.Fixture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.NoSuchFieldRuntimeException;
import org.jtester.utility.DateUtil;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolUtil {
    private static final Object dbNull = new Object();
    private static final Map<String, Object> system_symbols = new HashMap<String, Object>(){
        private static final long serialVersionUID = 2824018273733392296L;
        {
            this.put("date", DateUtil.currDateStr());
            this.put("datetime", DateUtil.currDateTimeStr());
            this.put("space", " ");
            this.put("at", "@");
        }
    };
    private static final String VARIABLE_REGEX = "[a-zA-Z0-9_\\-]+";
    private static final Pattern symbolPattern = Pattern.compile("@\\{([a-zA-Z0-9_\\-\\[\\]]+)\\}");

    public static void setSymbol(String name, Object value) {
        SymbolUtil.validateSymbol(name, true);
        Fixture.setSymbol((String)name, (Object)(value == null ? dbNull : value));
    }

    public static Object getSymbol(String name) {
        SymbolUtil.validateSymbol(name, true);
        int index = name.indexOf("[");
        if (index > 0) {
            String symbolName = StringHelper.trim(name.substring(0, index));
            String keyName = StringHelper.trim(name.substring(index + 1, name.length() - 1));
            Object symbol = Fixture.getSymbol((String)symbolName);
            if (symbol instanceof Map) {
                Object o = ((Map)symbol).get(keyName);
                return o;
            }
            try {
                Object o = FieldHelper.getFieldValue(symbol, keyName);
                return o;
            }
            catch (NoSuchFieldRuntimeException e) {
                return null;
            }
        }
        if (system_symbols.containsKey(name)) {
            return system_symbols.get(name);
        }
        Object value = Fixture.getSymbol((String)name);
        if (value == dbNull) {
            return null;
        }
        return value;
    }

    public static boolean hasSymbol(String var) {
        if (Fixture.hasSymbol((String)var)) {
            return true;
        }
        return system_symbols.containsKey(var);
    }

    public static void cleanSymbols() {
        Fixture.ClearSymbols();
    }

    public static void init() {
    }

    public static void setSymbol(Map<String, ?> symbols) {
        for (Map.Entry<String, ?> symbol : symbols.entrySet()) {
            SymbolUtil.setSymbol(symbol.getKey(), symbol.getValue());
        }
    }

    private static final boolean validateSymbol(String name, boolean isThrowable) {
        if (StringHelper.isBlankOrNull(name)) {
            if (isThrowable) {
                throw new RuntimeException("the symbol name can't be null.");
            }
            return false;
        }
        int index = name.indexOf(91);
        String _name = name;
        String _key = "nokey";
        if (index >= 0 && name.endsWith("]")) {
            _name = name.substring(0, index);
            _key = name.substring(index + 1, name.length() - 1);
        } else if (index >= 0 && !name.endsWith("]")) {
            if (isThrowable) {
                throw new RuntimeException("the symbol's format must be 'variable[key]', but actual value is " + name);
            }
            return false;
        }
        boolean matchedName = _name.matches(VARIABLE_REGEX);
        boolean matchedKey = _key.matches(VARIABLE_REGEX);
        if (isThrowable) {
            if (!matchedName || !matchedKey) {
                String error = String.format("illegal symbol format, the symbol's format must be 'variable[key]', but actual value is '%s'", name);
                throw new RuntimeException(String.format(error, "symbol key", _key));
            }
            return true;
        }
        return matchedName && matchedKey;
    }

    public static final String replacedBySymbols(String text) {
        ArrayList<String> vars = new ArrayList<String>();
        Matcher mc = symbolPattern.matcher(text);
        while (mc.find()) {
            String name = mc.group(1);
            SymbolUtil.validateSymbol(name, true);
            vars.add(name);
        }
        String replaced = text;
        for (String var : vars) {
            Object o = SymbolUtil.getSymbol(var);
            String value = String.valueOf(o);
            if (value == null) continue;
            replaced = replaced.replace("@{" + var + "}", value);
        }
        return replaced;
    }
}

