/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.iassert.common.impl;

import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.collection.IsIn;
import ext.jtester.hamcrest.core.AllOf;
import ext.jtester.hamcrest.core.AnyOf;
import ext.jtester.hamcrest.core.Is;
import ext.jtester.hamcrest.core.IsAnything;
import ext.jtester.hamcrest.core.IsEqual;
import ext.jtester.hamcrest.core.IsNot;
import ext.jtester.hamcrest.core.IsNull;
import ext.jtester.hamcrest.core.IsSame;
import ext.jtester.hamcrest.object.HasToString;
import java.util.ArrayList;
import java.util.List;
import org.jtester.hamcrest.iassert.common.impl.Assert;
import org.jtester.hamcrest.iassert.common.intf.IAssert;
import org.jtester.hamcrest.iassert.common.intf.IBaseAssert;
import org.jtester.hamcrest.iassert.object.impl.StringAssert;
import org.jtester.hamcrest.iassert.object.intf.IStringAssert;
import org.jtester.hamcrest.matcher.clazz.ClassAssignFromMatcher;
import org.jtester.utility.ListHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAssert<T, E extends IAssert>
extends Assert<T, E>
implements IAssert<T, E>,
IBaseAssert<T, E> {
    public BaseAssert() {
    }

    public BaseAssert(Class<? extends IAssert> clazE) {
        super(clazE);
    }

    public BaseAssert(T value, Class<? extends IAssert> clazE) {
        super(value, clazE);
    }

    @Override
    public E isEqualTo(T expected) {
        Matcher<T> matcher = IsEqual.equalTo(expected);
        return this.assertThat(matcher);
    }

    @Override
    public E eq(T expected) {
        Matcher<T> matcher = IsEqual.equalTo(expected);
        return this.assertThat(matcher);
    }

    @Override
    public E isEqualTo(String message, T expected) {
        Matcher<T> matcher = IsEqual.equalTo(expected);
        return this.assertThat(message, matcher);
    }

    @Override
    public E notEqualTo(T expected) {
        Matcher<Matcher<T>> matcher = IsNot.not(IsEqual.equalTo(expected));
        return this.assertThat(matcher);
    }

    @Override
    public E clazIs(Class expected) {
        Matcher matcher = Is.isA(expected);
        return this.assertThat(matcher);
    }

    @Override
    public E clazIsSubFrom(Class claz) {
        ClassAssignFromMatcher matcher = new ClassAssignFromMatcher(claz);
        return this.assertThat(matcher);
    }

    @Override
    public E not(E matcher) {
        Matcher<E> _matcher = IsNot.not(matcher);
        return this.assertThat(_matcher);
    }

    @Override
    public E all(E matcher, E ... matchers) {
        List list = ListHelper.toList(matchers);
        list.add(matcher);
        Matcher _matcher = AllOf.allOf(list);
        return this.assertThat(_matcher);
    }

    @Override
    public E any(E matcher, E ... matchers) {
        List list = ListHelper.toList(matchers);
        list.add(matcher);
        AnyOf _matcher = AnyOf.anyOf(list);
        return this.assertThat(_matcher);
    }

    @Override
    public E in(T ... values) {
        Matcher<T> matcher = IsIn.isOneOf(values);
        return this.assertThat(matcher);
    }

    @Override
    public E notIn(T ... values) {
        Matcher<Matcher<T>> _matcher = IsNot.not(IsIn.isOneOf(values));
        return this.assertThat(_matcher);
    }

    @Override
    public E same(T value) {
        Matcher<T> _matcher = IsSame.sameInstance(value);
        return this.assertThat(_matcher);
    }

    @Override
    public E any() {
        Matcher<Object> _matcher = IsAnything.anything();
        return this.assertThat(_matcher);
    }

    @Override
    public E isNull() {
        Matcher<Object> _matcher = IsNull.nullValue();
        return this.assertThat(_matcher);
    }

    @Override
    public E isNull(String message) {
        Matcher<Object> _matcher = IsNull.nullValue();
        return this.assertThat(message, _matcher);
    }

    @Override
    public E notNull() {
        Matcher<Object> _matcher = IsNull.notNullValue();
        return this.assertThat(_matcher);
    }

    @Override
    public E notNull(String message) {
        Matcher<Object> _matcher = IsNull.notNullValue();
        return this.assertThat(message, _matcher);
    }

    @Override
    public E eqToString(String expected) {
        HasToString matcher = HasToString.hasToString(expected);
        return this.assertThat(matcher);
    }

    @Override
    public E eqToString(IStringAssert matcher) {
        HasToString _matcher = HasToString.hasToString(matcher);
        return this.assertThat(_matcher);
    }

    public IStringAssert toStringAssert() {
        StringAssert matcher = null;
        matcher = this.type == Assert.AssertType.AssertStyle ? new StringAssert(String.valueOf(this.value)) : new StringAssert(true);
        return matcher;
    }

    @Override
    public E notAny(Matcher matcher, Matcher ... matchers) {
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        ms.add(matcher);
        for (Matcher m : matchers) {
            ms.add(m);
        }
        Matcher _matcher = AnyOf.notAny(ms);
        return this.assertThat(_matcher);
    }

    @Override
    public E notAll(Matcher matcher, Matcher ... matchers) {
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        ms.add(matcher);
        for (Matcher m : matchers) {
            ms.add(m);
        }
        Matcher _matcher = AllOf.notAll(ms);
        return this.assertThat(_matcher);
    }
}

