/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.iassert.object.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jtester.hamcrest.iassert.common.impl.Assert;
import org.jtester.hamcrest.iassert.common.impl.ComparableAssert;
import org.jtester.hamcrest.iassert.object.intf.IDateAssert;
import org.jtester.hamcrest.matcher.LinkMatcher;
import org.jtester.hamcrest.matcher.calendar.DateFormatMatcher;
import org.jtester.hamcrest.matcher.calendar.DateParterMatcher;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.utility.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateAssert<T>
extends ComparableAssert<T, IDateAssert<T>>
implements IDateAssert<T> {
    public DateAssert(Class<T> clazz) {
        super(DateAssert.class);
        this.value = null;
        this.type = Assert.AssertType.MatcherStyle;
        this.link = new LinkMatcher();
        this.assertClaz = IDateAssert.class;
        this.valueClaz = clazz;
    }

    public DateAssert(T value, Class<T> clazz) {
        super(value, DateAssert.class);
        this.type = Assert.AssertType.AssertStyle;
        this.value = value;
        this.assertClaz = IDateAssert.class;
        this.valueClaz = clazz;
    }

    @Override
    public IDateAssert<T> isYear(int year) {
        return this.assertThat(year, DateParterMatcher.DateFieldType.YEAR);
    }

    @Override
    public IDateAssert<T> isYear(String year) {
        return this.assertThat(year, DateParterMatcher.DateFieldType.YEAR);
    }

    @Override
    public IDateAssert<T> isDay(int day) {
        return this.assertThat(day, DateParterMatcher.DateFieldType.DATE);
    }

    @Override
    public IDateAssert<T> isDay(String day) {
        return this.assertThat(day, DateParterMatcher.DateFieldType.DATE);
    }

    @Override
    public IDateAssert<T> isHour(int hour) {
        return this.assertThat(hour, DateParterMatcher.DateFieldType.HOUR);
    }

    @Override
    public IDateAssert<T> isHour(String hour) {
        return this.assertThat(hour, DateParterMatcher.DateFieldType.HOUR);
    }

    @Override
    public IDateAssert<T> isMinute(int minute) {
        return this.assertThat(minute, DateParterMatcher.DateFieldType.MINUTE);
    }

    @Override
    public IDateAssert<T> isMinute(String minute) {
        return this.assertThat(minute, DateParterMatcher.DateFieldType.MINUTE);
    }

    @Override
    public IDateAssert<T> isMonth(int month) {
        return this.assertThat(month, DateParterMatcher.DateFieldType.MONTH);
    }

    @Override
    public IDateAssert<T> isMonth(String month) {
        return this.assertThat(month, DateParterMatcher.DateFieldType.MONTH);
    }

    @Override
    public IDateAssert<T> isSecond(int second) {
        return this.assertThat(second, DateParterMatcher.DateFieldType.SECOND);
    }

    @Override
    public IDateAssert<T> isSecond(String second) {
        return this.assertThat(second, DateParterMatcher.DateFieldType.SECOND);
    }

    private IDateAssert<T> assertThat(int value, DateParterMatcher.DateFieldType type) {
        DateParterMatcher matcher = new DateParterMatcher(value, type);
        return (IDateAssert)this.assertThat(matcher);
    }

    private IDateAssert<T> assertThat(String value, DateParterMatcher.DateFieldType type) {
        DateParterMatcher matcher = new DateParterMatcher(Integer.valueOf(value), type);
        return (IDateAssert)this.assertThat(matcher);
    }

    @Override
    public IDateAssert<T> eqByFormat(String expected, String format) {
        DateFormatMatcher matcher = new DateFormatMatcher(format, expected);
        return (IDateAssert)this.assertThat(matcher);
    }

    @Override
    public IDateAssert<T> eqByFormat(String expected) {
        SimpleDateFormat df = DateUtil.getDateFormat(expected);
        DateFormatMatcher matcher = new DateFormatMatcher(df, expected);
        return (IDateAssert)this.assertThat(matcher);
    }

    @Override
    public IDateAssert<T> isEqualTo(long time) {
        Date date = new Date(time);
        return (IDateAssert)this.isEqualTo(date, new EqMode[0]);
    }

    @Override
    public IDateAssert<T> isEqualTo(Calendar calendar) {
        Date date = calendar.getTime();
        return (IDateAssert)this.isEqualTo(date, new EqMode[0]);
    }
}

