/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.iassert.object.impl;

import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.MatcherAssert;
import ext.jtester.hamcrest.core.Is;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jtester.hamcrest.iassert.common.impl.AllAssert;
import org.jtester.hamcrest.iassert.common.impl.Assert;
import org.jtester.hamcrest.iassert.common.intf.IAssert;
import org.jtester.hamcrest.iassert.object.impl.CollectionAssert;
import org.jtester.hamcrest.iassert.object.impl.MapAssert;
import org.jtester.hamcrest.iassert.object.impl.StringAssert;
import org.jtester.hamcrest.iassert.object.intf.ICollectionAssert;
import org.jtester.hamcrest.iassert.object.intf.IJSONAssert;
import org.jtester.hamcrest.iassert.object.intf.IMapAssert;
import org.jtester.hamcrest.iassert.object.intf.IStringAssert;
import org.jtester.json.helper.JSONArray;
import org.jtester.json.helper.JSONMap;
import org.jtester.json.helper.JSONObject;
import org.jtester.json.helper.JSONScanner;
import org.jtester.json.helper.JSONSingle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONAssert
extends AllAssert<Object, JSONAssert>
implements IJSONAssert {
    public JSONAssert(String json, Class<? extends IAssert<?, ?>> clazE) {
        super(clazE);
        JSONObject temp = JSONScanner.scnJSON(json);
        this.value = JSONAssert.convert(temp);
        this.type = Assert.AssertType.AssertStyle;
    }

    @Override
    public ICollectionAssert isJSONArray() {
        CollectionAssert collectionAssert = null;
        Matcher<LinkedList> matcher = Is.isA(LinkedList.class);
        if (this.type == Assert.AssertType.AssertStyle) {
            if (this.value instanceof LinkedList) {
                collectionAssert = new CollectionAssert((LinkedList)this.value);
            } else {
                MatcherAssert.assertThat(this.value, matcher);
            }
        } else {
            collectionAssert = new CollectionAssert();
        }
        return (ICollectionAssert)collectionAssert.assertThat(matcher);
    }

    @Override
    public IMapAssert isJSONMap() {
        MapAssert mapAssert = null;
        Matcher<LinkedHashMap> matcher = Is.isA(LinkedHashMap.class);
        if (this.type == Assert.AssertType.AssertStyle) {
            if (this.value instanceof Map) {
                mapAssert = new MapAssert((Map)this.value);
            } else {
                MatcherAssert.assertThat(this.value, matcher);
            }
        } else {
            mapAssert = new MapAssert();
        }
        return (IMapAssert)mapAssert.assertThat(matcher);
    }

    @Override
    public IStringAssert isSimple() {
        StringAssert stringAssert = null;
        Matcher<String> matcher = Is.isA(String.class);
        if (this.type == Assert.AssertType.AssertStyle) {
            if (this.value instanceof String) {
                stringAssert = new StringAssert((String)this.value);
            } else {
                MatcherAssert.assertThat(this.value, matcher);
            }
        } else {
            stringAssert = new StringAssert();
        }
        return (IStringAssert)stringAssert.assertThat(matcher);
    }

    private static Object convert(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONSingle) {
            return ((JSONSingle)obj).toStringValue();
        }
        if (obj instanceof JSONMap) {
            return JSONAssert.convert((JSONMap)obj);
        }
        if (obj instanceof JSONArray) {
            return JSONAssert.convert((JSONArray)obj);
        }
        throw new RuntimeException("unknown json type:" + obj.getClass().getName());
    }

    private static LinkedHashMap convert(JSONMap map) {
        LinkedHashMap<Object, Object> linkedMap = new LinkedHashMap<Object, Object>();
        for (JSONObject key : map.keySet()) {
            Object key_obj = JSONAssert.convert(key);
            JSONObject value = map.get(key);
            Object value_obj = JSONAssert.convert(value);
            linkedMap.put(key_obj, value_obj);
        }
        return linkedMap;
    }

    private static LinkedList convert(JSONArray array) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (JSONObject o : array) {
            Object item = JSONAssert.convert(o);
            list.add(item);
        }
        return list;
    }
}

