/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.iassert.object.impl;

import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.core.AnyOf;
import ext.jtester.hamcrest.core.IsNot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jtester.hamcrest.iassert.common.impl.ComparableAssert;
import org.jtester.hamcrest.iassert.object.intf.IStringAssert;
import org.jtester.hamcrest.matcher.mockito.Matches;
import org.jtester.hamcrest.matcher.string.StringBlankMatcher;
import org.jtester.hamcrest.matcher.string.StringContainMatcher;
import org.jtester.hamcrest.matcher.string.StringContainsInOrder;
import org.jtester.hamcrest.matcher.string.StringEndWithMatcher;
import org.jtester.hamcrest.matcher.string.StringEqualMatcher;
import org.jtester.hamcrest.matcher.string.StringMode;
import org.jtester.hamcrest.matcher.string.StringStartWithMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAssert
extends ComparableAssert<String, IStringAssert>
implements IStringAssert {
    public StringAssert() {
        super(IStringAssert.class);
        this.valueClaz = String.class;
    }

    public StringAssert(boolean toString) {
        super(IStringAssert.class);
        if (toString) {
            this.value = "toString";
        }
        this.valueClaz = String.class;
    }

    public StringAssert(String str) {
        super(str, IStringAssert.class);
        this.valueClaz = String.class;
    }

    @Override
    public IStringAssert isEqualTo(String expected, StringMode ... modes) {
        StringEqualMatcher matcher = new StringEqualMatcher(expected);
        matcher.setStringModes(modes);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert contains(String expected, StringMode ... modes) {
        StringContainMatcher matcher = new StringContainMatcher(new String[]{expected}, modes);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert contains(String[] expecteds, StringMode ... modes) {
        StringContainMatcher matcher = new StringContainMatcher(expecteds, modes);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert end(String expected, StringMode ... modes) {
        StringEndWithMatcher matcher = new StringEndWithMatcher(expected);
        matcher.setStringModes(modes);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert start(String expected, StringMode ... modes) {
        StringStartWithMatcher matcher = new StringStartWithMatcher(expected);
        matcher.setStringModes(modes);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert notContain(String sub, StringMode ... modes) {
        StringContainMatcher matcher = new StringContainMatcher(new String[]{sub}, modes);
        Matcher<StringContainMatcher> _matcher = IsNot.not(matcher);
        return (IStringAssert)this.assertThat(_matcher);
    }

    @Override
    public IStringAssert notContain(String[] subs, StringMode ... modes) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String sub : subs) {
            StringContainMatcher matcher = new StringContainMatcher(new String[]{sub}, modes);
            matchers.add(matcher);
        }
        Matcher _matcher = AnyOf.notAny(matchers);
        return (IStringAssert)this.assertThat(_matcher);
    }

    @Override
    public IStringAssert eqIgnoreCase(String string) {
        StringEqualMatcher matcher = new StringEqualMatcher(string);
        matcher.setStringModes(StringMode.IgnoreCase);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert eqWithStripSpace(String string) {
        StringEqualMatcher matcher = new StringEqualMatcher(string);
        matcher.setStringModes(StringMode.SameAsSpace);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert eqIgnoreSpace(String string) {
        StringEqualMatcher matcher = new StringEqualMatcher(string);
        matcher.setStringModes(StringMode.IgnoreSpace);
        return (IStringAssert)this.assertThat("expect equal when ignore all space.", matcher);
    }

    @Override
    public IStringAssert regular(String regex) {
        Matches matcher = new Matches(regex);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert notBlank() {
        Matcher<StringBlankMatcher> matcher = IsNot.not(new StringBlankMatcher());
        return (IStringAssert)this.assertThat("expect string is blank", matcher);
    }

    @Override
    public IStringAssert containsInOrder(String ... expecteds) {
        List<String> substrings = Arrays.asList(expecteds);
        StringContainsInOrder matcher = new StringContainsInOrder(substrings);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert containsInOrder(String[] expecteds, StringMode ... modes) {
        List<String> substrings = Arrays.asList(expecteds);
        StringContainsInOrder matcher = new StringContainsInOrder(substrings, modes);
        return (IStringAssert)this.assertThat(matcher);
    }

    @Override
    public IStringAssert eq(String expected, StringMode ... modes) {
        return this.isEqualTo(expected, modes);
    }
}

