/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.array;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMatcher
extends BaseMatcher<Map<?, ?>> {
    private Object expected;
    private MapMatcherType type;

    public MapMatcher(Object expected, MapMatcherType type) {
        this.expected = expected;
        this.type = type;
    }

    @Override
    public boolean matches(Object _actual) {
        if (_actual == null || !(_actual instanceof Map)) {
            return false;
        }
        Map actual = (Map)_actual;
        if (this.type == MapMatcherType.KEY) {
            return actual.containsKey(this.expected);
        }
        return actual.containsValue(this.expected);
    }

    @Override
    public void describeTo(Description description) {
        if (this.type == MapMatcherType.KEY) {
            description.appendText(String.format("the map must have the key %s", this.expected));
        } else {
            description.appendText(String.format("the map must have the value %s", this.expected));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapMatcherType {
        KEY,
        VALUE;

    }
}

