/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.array;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import java.util.Collection;
import org.jtester.utility.ArrayHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeOrLengthMatcher
extends BaseMatcher<Collection<?>> {
    private int size;
    private SizeOrLengthMatcherType type;
    int actualSize = 0;

    public SizeOrLengthMatcher(int size, SizeOrLengthMatcherType type) {
        this.size = size;
        this.type = type;
    }

    @Override
    public boolean matches(Object actual) {
        if (actual == null) {
            return false;
        }
        this.actualSize = ArrayHelper.sizeOf(actual);
        switch (this.type) {
            case EQ: {
                return this.actualSize == this.size;
            }
            case GT: {
                return this.actualSize > this.size;
            }
            case GE: {
                return this.actualSize >= this.size;
            }
            case LT: {
                return this.actualSize < this.size;
            }
            case LE: {
                return this.actualSize <= this.size;
            }
        }
        return this.actualSize != this.size;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format(this.type.description(), this.size));
        description.appendText(", but actual size is[" + this.actualSize + "].");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizeOrLengthMatcherType {
        EQ{

            public String description() {
                return "size of collection or array must equal to %d";
            }
        }
        ,
        GT{

            public String description() {
                return "size of collection or array must be greater then %d";
            }
        }
        ,
        GE{

            public String description() {
                return "size of collection or array must equal to or greater then %d";
            }
        }
        ,
        LT{

            public String description() {
                return "size of collection or array must be less then %d";
            }
        }
        ,
        LE{

            public String description() {
                return "size of collection or array must equal to or less then %d";
            }
        }
        ,
        NE{

            public String description() {
                return "size of collection or array must not equal to %d";
            }
        };


        public abstract String description();
    }
}

