/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.calendar;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import java.util.Calendar;
import java.util.Date;
import org.jtester.exception.JTesterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateParterMatcher
extends BaseMatcher<Date> {
    private int expected;
    private DateFieldType type;

    public DateParterMatcher(int expected, DateFieldType type) {
        this.expected = expected;
        this.type = type;
    }

    @Override
    public boolean matches(Object actual) {
        if (actual == null) {
            throw new JTesterException("the actual value can't be null");
        }
        Calendar cal = null;
        if (actual instanceof Calendar) {
            cal = (Calendar)actual;
        } else if (actual instanceof Date) {
            cal = Calendar.getInstance();
            cal.setTime((Date)actual);
        } else {
            throw new JTesterException("the actual value must be a java.util.Date instance or a java.util.Calendar instance");
        }
        int value = cal.get(this.type.calendarField());
        if (this.type == DateFieldType.MONTH) {
            return this.expected == value + 1;
        }
        return this.expected == value;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format(this.type.description(), this.expected));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateFieldType {
        YEAR{

            public int calendarField() {
                return 1;
            }

            public String description() {
                return "the year of expected time must equal to %d";
            }
        }
        ,
        MONTH{

            public int calendarField() {
                return 2;
            }

            public String description() {
                return "the month of expected time must equal to %d";
            }
        }
        ,
        DATE{

            public int calendarField() {
                return 5;
            }

            public String description() {
                return "the day/month of expected time must equal to %d";
            }
        }
        ,
        HOUR{

            public int calendarField() {
                return 11;
            }

            public String description() {
                return "the hour of expected time must equal to %d";
            }
        }
        ,
        MINUTE{

            public int calendarField() {
                return 12;
            }

            public String description() {
                return "the minute of expected time must equal to %d";
            }
        }
        ,
        SECOND{

            public int calendarField() {
                return 13;
            }

            public String description() {
                return "the second of expected time must equal to %d";
            }
        };


        public abstract int calendarField();

        public abstract String description();
    }
}

