/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.file;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExistsMatcher
extends BaseMatcher<File> {
    private File expected;
    private FileExistsMatcherType type;

    public FileExistsMatcher(File file, FileExistsMatcherType type) {
        this.expected = file;
        this.type = type;
    }

    @Override
    public boolean matches(Object actual) {
        if (this.type == FileExistsMatcherType.ISEXISTS) {
            return this.expected.exists();
        }
        return !this.expected.exists();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format(this.type.description(), this.expected.getAbsolutePath()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileExistsMatcherType {
        ISEXISTS{

            public String description() {
                return "file '%s' has existed";
            }
        }
        ,
        UNEXISTS{

            public String description() {
                return "file '%s' doesn't exist";
            }
        };


        public abstract String description();
    }
}

