/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.StringDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.core.IJTester;
import org.jtester.exception.NoSuchFieldRuntimeException;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparatorFactory;
import org.jtester.hamcrest.matcher.property.report.DefaultDifferenceReport;
import org.jtester.utility.ArrayHelper;
import org.jtester.utility.ListHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapListPropertyEqaulMatcher
extends BaseMatcher {
    private final List<IJTester.DataMap> expected;
    private EqMode[] modes;
    private StringDescription self = new StringDescription();
    private Difference difference;

    public MapListPropertyEqaulMatcher(List<IJTester.DataMap> expected, EqMode[] modes) {
        this.expected = expected;
        this.modes = modes;
        if (expected == null) {
            throw new AssertionError((Object)"MapPropertyEqaulMatcher, the expected map can't be null.");
        }
    }

    @Override
    public boolean matches(Object actual) {
        if (actual == null) {
            this.self.appendText("MapPropertyEqaulMatcher, the actual object can't be null or list/array.");
            return false;
        }
        if (!ArrayHelper.isCollOrArray(actual)) {
            this.self.appendText("MapPropertyEqaulMatcher, the actual object must be an array or a list.");
            return false;
        }
        List list = ListHelper.toList(actual);
        if (this.expected.size() != list.size()) {
            this.self.appendText("MapPropertyEqaulMatcher, the size ofexpeced object is " + this.expected.size() + ", but the size of actual list is " + list.size() + ".");
            return false;
        }
        Set<String> keys = this.getAllKeys();
        List<Map<String, ?>> actuals = this.getObjectArrayFromList(list, keys, false);
        List<Map<String, ?>> expecteds = this.getObjectArrayFromList(this.expected, keys, true);
        ReflectionComparator reflectionComparator = ReflectionComparatorFactory.createRefectionComparator(this.modes);
        this.difference = reflectionComparator.getDifference(expecteds, actuals);
        return this.difference == null;
    }

    private List<Map<String, ?>> getObjectArrayFromList(List list, Set<String> keys, boolean isExpected) {
        ArrayList result = new ArrayList();
        for (Object o : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : keys) {
                try {
                    Object value = PropertyAccessor.getPropertyByOgnl(o, key, true);
                    map.put(key, value);
                }
                catch (NoSuchFieldRuntimeException e) {
                    if (isExpected) {
                        map.put(key, null);
                        continue;
                    }
                    throw e;
                }
            }
            result.add(map);
        }
        return result;
    }

    private Set<String> getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (IJTester.DataMap map : this.expected) {
            Set set = map.keySet();
            keys.addAll(set);
        }
        return keys;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(this.self.toString());
        if (this.difference != null) {
            DefaultDifferenceReport differenceReport = new DefaultDifferenceReport();
            description.appendText(differenceReport.createReport(this.difference));
        }
    }
}

