/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.StringDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.core.IJTester;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparatorFactory;
import org.jtester.hamcrest.matcher.property.report.DefaultDifferenceReport;
import org.jtester.utility.ArrayHelper;
import org.jtester.utility.ListHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyEqaulMatcher
extends BaseMatcher {
    private final IJTester.DataMap expected;
    private EqMode[] modes;
    private StringDescription self = new StringDescription();
    private Difference difference;

    public MapPropertyEqaulMatcher(IJTester.DataMap expected, EqMode[] modes) {
        this.expected = expected;
        this.modes = modes;
        if (expected == null) {
            throw new AssertionError((Object)"MapPropertyEqaulMatcher, the expected map can't be null.");
        }
    }

    @Override
    public boolean matches(Object actual) {
        if (actual == null) {
            this.self.appendText("MapPropertyEqaulMatcher, the actual object can't be null or list/array.");
            return false;
        }
        ArrayList<IJTester.DataMap> expecteds = new ArrayList<IJTester.DataMap>();
        ArrayList<Map<String, Object>> actuals = new ArrayList<Map<String, Object>>();
        List list = ListHelper.toList(actual);
        for (Object item : list) {
            if (item == null) {
                actuals.add(null);
                expecteds.add(this.expected);
                continue;
            }
            if (ArrayHelper.isCollOrArray(item)) {
                this.self.appendText("MapPropertyEqaulMatcher, the item of actual list can't list/array.");
                return false;
            }
            Map<String, Object> map = this.getValueByMapKeys(item);
            actuals.add(map);
            expecteds.add(this.expected);
        }
        ReflectionComparator reflectionComparator = ReflectionComparatorFactory.createRefectionComparator(this.modes);
        this.difference = reflectionComparator.getDifference(expecteds, actuals);
        return this.difference == null;
    }

    private Map<String, Object> getValueByMapKeys(Object actualItem) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String property : this.expected.keySet()) {
            Object value = PropertyAccessor.getPropertyByOgnl(actualItem, property, true);
            map.put(property, value);
        }
        return map;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(this.self.toString());
        if (this.difference != null) {
            DefaultDifferenceReport differenceReport = new DefaultDifferenceReport();
            description.appendText(differenceReport.createReport(this.difference));
        }
    }
}

