/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.hamcrest.matcher.property.ReflectionEqualMatcher;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesArrayRefEqMatcher
extends BaseMatcher<Object> {
    private String[] properties;
    private Object[][] expected;
    ReflectionEqualMatcher matcher;
    private Object[][] propertyValues = null;

    public PropertiesArrayRefEqMatcher(String[] properties, Object[][] expected, EqMode ... modes) {
        if (properties == null || properties.length == 0) {
            throw new RuntimeException("properties list can't be null!");
        }
        this.properties = properties;
        this.expected = expected;
        this.matcher = new ReflectionEqualMatcher((T[])expected, modes);
    }

    @Override
    public boolean matches(Object actual) {
        this.propertyValues = PropertyAccessor.getArrayItemProperties(actual, this.properties);
        return this.matcher.matches(this.propertyValues);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("the propery[" + StringHelper.toString(this.properties) + "] of object must match");
        description.appendText(String.format(",but actual value is:%s, not matched value[%s]", StringHelper.toString(this.propertyValues), StringHelper.toString(this.expected)));
    }
}

