/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.Matcher;
import java.util.List;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.utility.ArrayHelper;
import org.jtester.utility.ListHelper;

public class PropertyAnyItemMatcher
extends BaseMatcher {
    private String property;
    private Matcher matcher;
    private final StringBuilder buff = new StringBuilder();
    private List actualItems;

    public PropertyAnyItemMatcher(String property, Matcher matcher) {
        this.property = property;
        this.matcher = matcher;
        if (this.property == null) {
            throw new RuntimeException("the properties can't be null.");
        }
    }

    public boolean matches(Object actual) {
        if (!ArrayHelper.isCollOrArray(actual)) {
            this.buff.append("PropertyItemsMatcher, the actual value must be a array or collection.");
            return false;
        }
        List list = ListHelper.toList(actual);
        this.actualItems = PropertyAccessor.getPropertyOfList(list, this.property, true);
        for (Object item : this.actualItems) {
            boolean match = this.matcher.matches(item);
            if (!match) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the propery" + this.property + " values of object is:\n");
        description.appendText(ListHelper.toString(this.actualItems)).appendText("\n");
        description.appendDescriptionOf(this.matcher);
    }
}

