/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import java.util.List;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparatorFactory;
import org.jtester.hamcrest.matcher.property.report.DefaultDifferenceReport;
import org.jtester.utility.ArrayHelper;
import org.jtester.utility.ListHelper;

public class PropertyEqualMatcher
extends BaseMatcher {
    private final Object expected;
    private final String property;
    private final EqMode[] modes;
    private final StringBuilder buff = new StringBuilder();
    private Difference difference;

    public PropertyEqualMatcher(Object expected, String properties, EqMode[] modes) {
        this.expected = expected;
        this.property = properties;
        if (this.property == null) {
            throw new RuntimeException("the properties can't be empty.");
        }
        this.modes = modes;
    }

    public PropertyEqualMatcher(Object expected, String property) {
        this(expected, property, null);
    }

    public boolean matches(Object actual) {
        if (actual == null) {
            this.buff.append("properties equals matcher, the actual value can't be null.");
            return false;
        }
        if (ArrayHelper.isCollOrArray(actual)) {
            List list = ListHelper.toList(actual);
            return this.matchList(list);
        }
        return this.matchPoJo(actual);
    }

    private boolean matchList(List array) {
        List actuals = PropertyAccessor.getPropertyOfList(array, this.property, true);
        List expected = ListHelper.toList(this.expected);
        if (ArrayHelper.isCollOrArray(this.expected)) {
            expected = PropertyAccessor.getPropertyOfList(expected, this.property, false);
        }
        ReflectionComparator reflectionComparator = ReflectionComparatorFactory.createRefectionComparator(this.modes);
        this.difference = reflectionComparator.getDifference(expected, actuals);
        return this.difference == null;
    }

    private boolean matchPoJo(Object pojo) {
        Object actuals = PropertyAccessor.getPropertyByOgnl(pojo, this.property, true);
        Object expects = this.expected;
        if (!ArrayHelper.isCollOrArray(this.expected)) {
            expects = PropertyAccessor.getPropertyByOgnl(this.expected, this.property, false);
        }
        ReflectionComparator reflectionComparator = ReflectionComparatorFactory.createRefectionComparator(this.modes);
        this.difference = reflectionComparator.getDifference(expects, actuals);
        return this.difference == null;
    }

    public void describeTo(Description description) {
        description.appendText(this.buff.toString());
        if (this.difference != null) {
            String message = "Incorrect value for properties: " + ArrayHelper.toString(this.property);
            description.appendText(message);
            DefaultDifferenceReport differenceReport = new DefaultDifferenceReport();
            description.appendText(differenceReport.createReport(this.difference));
        }
    }
}

