/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.hamcrest.matcher.string.StringMode;
import org.jtester.utility.ArrayHelper;

public class PropertyEqualStringMatcher
extends BaseMatcher {
    private final String expected;
    private final String property;
    private final StringMode[] modes;
    private final StringBuilder buff = new StringBuilder();

    public PropertyEqualStringMatcher(String expected, String properties, StringMode[] modes) {
        this.expected = expected;
        this.property = properties;
        if (this.property == null) {
            throw new RuntimeException("the properties can't be empty.");
        }
        this.modes = modes;
    }

    public PropertyEqualStringMatcher(String expected, String property) {
        this(expected, property, null);
    }

    public boolean matches(Object actual) {
        boolean match;
        if (actual == null) {
            this.buff.append("properties equals matcher, the actual value can't be null.");
            return false;
        }
        if (ArrayHelper.isCollOrArray(actual)) {
            this.buff.append("PropertyEqualStringMatcher can only accept PoJo Object or Map, but actual is Array/List.");
            return false;
        }
        Object propValue = PropertyAccessor.getPropertyByOgnl(actual, this.property, true);
        String expectedString = StringMode.getStringByMode(this.expected, this.modes);
        String actualString = StringMode.getStringByMode(propValue == null ? null : String.valueOf(propValue), this.modes);
        boolean bl = expectedString == null ? actualString == null : (match = expectedString.equals(actualString));
        if (!match) {
            this.description(expectedString, actualString);
        }
        return match;
    }

    private void description(String expected, String actual) {
        this.buff.append("expected property eq by modes");
        this.buff.append(" ").append(expected);
        this.buff.append("\n, but actual string is:");
        this.buff.append(actual).append(".\n");
    }

    public void describeTo(Description description) {
        description.appendText(this.buff.toString());
    }
}

