/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property;

import ext.jtester.hamcrest.BaseMatcher;
import ext.jtester.hamcrest.Description;
import java.util.Collection;
import java.util.List;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparatorFactory;
import org.jtester.hamcrest.matcher.property.report.DefaultDifferenceReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionEqualMatcher
extends BaseMatcher {
    private Object expected;
    private EqMode[] modes;
    private Difference difference;

    public ReflectionEqualMatcher(Object expected, EqMode[] modes) {
        this.expected = expected;
        this.modes = modes == null ? null : (EqMode[])modes.clone();
    }

    public ReflectionEqualMatcher(Collection expected, EqMode[] modes) {
        this.expected = expected;
        this.modes = modes == null ? null : (EqMode[])modes.clone();
    }

    public <T> ReflectionEqualMatcher(T[] expected, EqMode[] modes) {
        this.expected = expected == null ? null : (Object[])expected.clone();
        this.modes = modes == null ? null : (EqMode[])modes.clone();
    }

    public ReflectionEqualMatcher(List expected, EqMode[] modes) {
        this.expected = expected;
        this.modes = modes == null ? null : (EqMode[])modes.clone();
    }

    @Override
    public boolean matches(Object actual) {
        ReflectionComparator reflectionComparator = ReflectionComparatorFactory.createRefectionComparator(this.modes);
        this.difference = reflectionComparator.getDifference(this.expected, actual);
        return this.difference == null;
    }

    @Override
    public void describeTo(Description description) {
        if (this.difference != null) {
            DefaultDifferenceReport differenceReport = new DefaultDifferenceReport();
            description.appendText(differenceReport.createReport(this.difference));
        }
    }
}

