/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.comparator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jtester.hamcrest.matcher.property.comparator.Comparator;
import org.jtester.hamcrest.matcher.property.difference.CollectionDifference;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.utility.ListHelper;

public class CollectionComparator
implements Comparator {
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return !(!left.getClass().isArray() && !(left instanceof Collection) || !right.getClass().isArray() && !(right instanceof Collection));
    }

    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        List leftList = ListHelper.toList(left);
        List rightList = ListHelper.toList(right);
        int elementIndex = -1;
        CollectionDifference difference = new CollectionDifference("Different elements", left, right, leftList, rightList);
        Iterator leftIterator = leftList.iterator();
        Iterator rightIterator = rightList.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            ++elementIndex;
            Difference elementDifference = reflectionComparator.getDifference(leftIterator.next(), rightIterator.next(), onlyFirstDifference);
            if (elementDifference == null) continue;
            difference.addElementDifference(elementIndex, elementDifference);
            if (!onlyFirstDifference) continue;
            return difference;
        }
        int leftElementIndex = elementIndex;
        while (leftIterator.hasNext()) {
            leftIterator.next();
            difference.addLeftMissingIndex(++leftElementIndex);
        }
        int rightElementIndex = elementIndex;
        while (rightIterator.hasNext()) {
            rightIterator.next();
            difference.addRightMissingIndex(++rightElementIndex);
        }
        if (difference.getElementDifferences().isEmpty() && difference.getLeftMissingIndexes().isEmpty() && difference.getRightMissingIndexes().isEmpty()) {
            return null;
        }
        return difference;
    }
}

