/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.comparator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jtester.hamcrest.matcher.property.comparator.Comparator;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.difference.UnorderedCollectionDifference;
import org.jtester.hamcrest.matcher.property.reflection.MatchingScoreCalculator;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.utility.ListHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LenientOrderCollectionComparator
implements Comparator {
    @Override
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return !(!left.getClass().isArray() && !(left instanceof Collection) || !right.getClass().isArray() && !(right instanceof Collection));
    }

    @Override
    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        List left_coll = ListHelper.toList(left);
        ArrayList<Object> leftList = new ArrayList<Object>(left_coll);
        List right_coll = ListHelper.toList(right);
        ArrayList<Object> rightList = new ArrayList<Object>(right_coll);
        boolean isEqual = this.isEqual(leftList, rightList, 0, reflectionComparator);
        if (isEqual) {
            return null;
        }
        UnorderedCollectionDifference difference = new UnorderedCollectionDifference("Collections/arrays are different", left, right, leftList, rightList);
        if (onlyFirstDifference) {
            return difference;
        }
        this.fillAllDifferences(leftList, rightList, reflectionComparator, difference);
        this.fillBestMatchingIndexes(leftList, rightList, difference);
        return difference;
    }

    protected boolean isEqual(ArrayList<Object> leftList, ArrayList<Object> rightList, int leftIndex, ReflectionComparator reflectionComparator) {
        if (leftIndex >= leftList.size()) {
            return rightList.isEmpty();
        }
        Object leftValue = leftList.get(leftIndex);
        for (int rightIndex = 0; rightIndex < rightList.size(); ++rightIndex) {
            Object rightValue = rightList.get(rightIndex);
            Difference elementDifference = reflectionComparator.getDifference(leftValue, rightValue, true);
            if (elementDifference != null) continue;
            ArrayList rightListClone = (ArrayList)rightList.clone();
            rightListClone.remove(rightIndex);
            boolean isEqual = this.isEqual(leftList, rightListClone, leftIndex + 1, reflectionComparator);
            if (!isEqual) continue;
            return true;
        }
        return false;
    }

    protected void fillAllDifferences(ArrayList<Object> leftList, ArrayList<Object> rightList, ReflectionComparator reflectionComparator, UnorderedCollectionDifference difference) {
        for (int leftIndex = 0; leftIndex < leftList.size(); ++leftIndex) {
            Object leftValue = leftList.get(leftIndex);
            for (int rightIndex = 0; rightIndex < rightList.size(); ++rightIndex) {
                Object rightValue = rightList.get(rightIndex);
                Difference elementDifference = reflectionComparator.getDifference(leftValue, rightValue, false);
                difference.addElementDifference(leftIndex, rightIndex, elementDifference);
            }
        }
    }

    protected void fillBestMatchingIndexes(ArrayList<Object> leftList, ArrayList<Object> rightList, UnorderedCollectionDifference difference) {
        ArrayList<Integer> leftIndexes = this.createIndexList(leftList.size());
        ArrayList<Integer> rightIndexes = this.createIndexList(rightList.size());
        this.removeMatchingIndexes(leftIndexes, rightIndexes, difference);
        this.setBestMatchingIndexes(leftIndexes, rightIndexes, difference);
    }

    protected void setBestMatchingIndexes(ArrayList<Integer> leftIndexes, ArrayList<Integer> rightIndexes, UnorderedCollectionDifference difference) {
        MatchingScoreCalculator matchingScoreCalculator = this.createMatchingScoreCalculator();
        Map<Integer, Map<Integer, Difference>> differences = difference.getElementDifferences();
        for (Integer leftIndex : leftIndexes) {
            int score = Integer.MAX_VALUE;
            for (Integer rightIndex : rightIndexes) {
                Difference elementDifference = differences.get(leftIndex).get(rightIndex);
                int matchingScore = matchingScoreCalculator.calculateMatchingScore(elementDifference);
                if (matchingScore >= score) continue;
                score = matchingScore;
                difference.setBestMatchingIndexes(leftIndex, rightIndex);
            }
        }
    }

    protected void removeMatchingIndexes(ArrayList<Integer> leftIndexes, ArrayList<Integer> rightIndexes, UnorderedCollectionDifference difference) {
        Map<Integer, Map<Integer, Difference>> differences = difference.getElementDifferences();
        Iterator<Integer> rightIterator = rightIndexes.iterator();
        while (rightIterator.hasNext()) {
            int rightIndex = rightIterator.next();
            Iterator<Integer> leftIterator = leftIndexes.iterator();
            while (leftIterator.hasNext()) {
                int leftIndex = leftIterator.next();
                Difference elementDifference = differences.get(leftIndex).get(rightIndex);
                if (elementDifference != null) continue;
                rightIterator.remove();
                leftIterator.remove();
            }
        }
    }

    protected ArrayList<Integer> createIndexList(int size) {
        ArrayList<Integer> leftIndexes = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            leftIndexes.add(i);
        }
        return leftIndexes;
    }

    protected MatchingScoreCalculator createMatchingScoreCalculator() {
        return new MatchingScoreCalculator();
    }
}

