/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.comparator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jtester.hamcrest.matcher.property.comparator.Comparator;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.difference.MapDifference;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparatorFactory;

public class MapComparator
implements Comparator {
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return left instanceof Map && right instanceof Map;
    }

    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        Map leftMap = (Map)left;
        Map rightMap = (Map)right;
        HashMap rightCopy = new HashMap(rightMap);
        ReflectionComparator keyReflectionComparator = ReflectionComparatorFactory.createRefectionComparator(new EqMode[0]);
        MapDifference difference = new MapDifference("Different elements", left, right, leftMap, rightMap);
        for (Map.Entry leftEntry : leftMap.entrySet()) {
            Object leftKey = leftEntry.getKey();
            Object leftValue = leftEntry.getValue();
            boolean found = false;
            Iterator rightIterator = rightCopy.entrySet().iterator();
            while (rightIterator.hasNext()) {
                Map.Entry rightEntry = rightIterator.next();
                Object rightKey = rightEntry.getKey();
                Object rightValue = rightEntry.getValue();
                boolean isKeyEqual = keyReflectionComparator.isEqual(leftKey, rightKey);
                if (!isKeyEqual) continue;
                found = true;
                rightIterator.remove();
                Difference elementDifference = reflectionComparator.getDifference(leftValue, rightValue, onlyFirstDifference);
                if (elementDifference == null) break;
                difference.addValueDifference(leftKey, elementDifference);
                if (!onlyFirstDifference) break;
                return difference;
            }
            if (found) continue;
            difference.addLeftMissingKey(leftKey);
        }
        for (Map.Entry rightKey : rightCopy.keySet()) {
            difference.addRightMissingKey(rightKey);
        }
        if (difference.getValueDifferences().isEmpty() && difference.getLeftMissingKeys().isEmpty() && difference.getRightMissingKeys().isEmpty()) {
            return null;
        }
        return difference;
    }
}

