/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.comparator;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jtester.hamcrest.matcher.property.comparator.Comparator;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.utility.DateUtil;

public class SimpleCasesComparator
implements Comparator {
    public boolean canCompare(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return true;
        }
        if ((left instanceof Character || left instanceof Number) && (right instanceof Character || right instanceof Number)) {
            return true;
        }
        if (left.getClass().getName().startsWith("java.lang") || right.getClass().getName().startsWith("java.lang")) {
            return true;
        }
        return left instanceof Enum && right instanceof Enum;
    }

    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        if (left == right) {
            return null;
        }
        if (left == null) {
            return new Difference("Left value null", left, right);
        }
        if (right == null) {
            return new Difference("Right value null", left, right);
        }
        if ((left instanceof Character || left instanceof Number) && (right instanceof Character || right instanceof Number)) {
            Double rightDouble;
            Double leftDouble = this.getDoubleValue(left);
            if (leftDouble.equals(rightDouble = this.getDoubleValue(right))) {
                return null;
            }
            return new Difference("Different primitive values", left, right);
        }
        if (left.getClass() == String.class && Date.class.isAssignableFrom(right.getClass())) {
            SimpleDateFormat df = DateUtil.getDateFormat((String)left);
            right = df.format((Date)right);
        }
        if (left.getClass().getName().startsWith("java.lang") || right.getClass().getName().startsWith("java.lang")) {
            if (left.equals(right)) {
                return null;
            }
            return new Difference("Different object values", left, right);
        }
        if (left instanceof Enum && right instanceof Enum) {
            if (left.equals(right)) {
                return null;
            }
            return new Difference("Different enum values", left, right);
        }
        return null;
    }

    private Double getDoubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return ((Character)object).charValue();
    }
}

