/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.reflection;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jtester.exception.JTesterException;
import org.jtester.hamcrest.matcher.property.comparator.Comparator;
import org.jtester.hamcrest.matcher.property.difference.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionComparator {
    protected List<Comparator> comparators;
    protected Map<Object, Map<Object, Difference>> firstDifferenceCachedResults = new IdentityHashMap<Object, Map<Object, Difference>>();
    protected Map<Object, Map<Object, Difference>> allDifferencesCachedResults = new IdentityHashMap<Object, Map<Object, Difference>>();

    public ReflectionComparator(List<Comparator> comparators) {
        this.comparators = comparators;
    }

    public boolean isEqual(Object expectedValue, Object actualValue) {
        Difference difference = this.getDifference(expectedValue, actualValue, true);
        return difference == null;
    }

    public Difference getDifference(Object expectedValue, Object actualValue) {
        return this.getDifference(expectedValue, actualValue, false);
    }

    public Difference getDifference(Object expectedValue, Object actualValue, boolean onlyFirstDifference) {
        Map<Object, Difference> cachedResult = this.getCachedDifference(expectedValue, onlyFirstDifference);
        if (cachedResult != null) {
            if (cachedResult.containsKey(actualValue)) {
                return cachedResult.get(actualValue);
            }
        } else {
            cachedResult = new IdentityHashMap<Object, Difference>();
            this.saveResultInCache(expectedValue, cachedResult, onlyFirstDifference);
        }
        cachedResult.put(actualValue, null);
        boolean compared = false;
        Difference result = null;
        for (Comparator comparator : this.comparators) {
            boolean canCompare = comparator.canCompare(expectedValue, actualValue);
            if (!canCompare) continue;
            result = comparator.compare(expectedValue, actualValue, onlyFirstDifference, this);
            compared = true;
            break;
        }
        if (!compared) {
            throw new JTesterException("Could not determine differences. No comparator found that is able to compare the values. Left: " + expectedValue + ", right " + actualValue);
        }
        cachedResult.put(actualValue, result);
        return result;
    }

    protected void saveResultInCache(Object left, Map<Object, Difference> cachedResult, boolean onlyFirstDifference) {
        if (onlyFirstDifference) {
            this.firstDifferenceCachedResults.put(left, cachedResult);
        } else {
            this.allDifferencesCachedResults.put(left, cachedResult);
        }
    }

    protected Map<Object, Difference> getCachedDifference(Object left, boolean onlyFirstDifference) {
        if (onlyFirstDifference) {
            return this.firstDifferenceCachedResults.get(left);
        }
        return this.allDifferencesCachedResults.get(left);
    }
}

