/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.reflection;

import java.util.ArrayList;
import java.util.List;
import org.jtester.hamcrest.matcher.property.comparator.CollectionComparator;
import org.jtester.hamcrest.matcher.property.comparator.Comparator;
import org.jtester.hamcrest.matcher.property.comparator.HibernateProxyComparator;
import org.jtester.hamcrest.matcher.property.comparator.IgnoreDefaultsComparator;
import org.jtester.hamcrest.matcher.property.comparator.LenientDatesComparator;
import org.jtester.hamcrest.matcher.property.comparator.LenientNumberComparator;
import org.jtester.hamcrest.matcher.property.comparator.LenientOrderCollectionComparator;
import org.jtester.hamcrest.matcher.property.comparator.MapComparator;
import org.jtester.hamcrest.matcher.property.comparator.ObjectComparator;
import org.jtester.hamcrest.matcher.property.comparator.SimpleCasesComparator;
import org.jtester.hamcrest.matcher.property.reflection.EqMode;
import org.jtester.hamcrest.matcher.property.reflection.ReflectionComparator;
import org.jtester.utility.ListHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionComparatorFactory {
    protected static final Comparator LENIENT_DATES_COMPARATOR = new LenientDatesComparator();
    protected static final Comparator IGNORE_DEFAULTS_COMPARATOR = new IgnoreDefaultsComparator();
    protected static final Comparator LENIENT_NUMBER_COMPARATOR = new LenientNumberComparator();
    protected static final Comparator SIMPLE_CASES_COMPARATOR = new SimpleCasesComparator();
    protected static final Comparator LENIENT_ORDER_COMPARATOR = new LenientOrderCollectionComparator();
    protected static final Comparator COLLECTION_COMPARATOR = new CollectionComparator();
    protected static final Comparator MAP_COMPARATOR = new MapComparator();
    protected static final Comparator HIBERNATE_PROXY_COMPARATOR = new HibernateProxyComparator();
    protected static final Comparator OBJECT_COMPARATOR = new ObjectComparator();

    public static ReflectionComparator createRefectionComparator(EqMode ... modes) {
        List _modes = ListHelper.toList(modes);
        List<Comparator> comparators = ReflectionComparatorFactory.getComparatorChain(_modes);
        return new ReflectionComparator(comparators);
    }

    protected static List<Comparator> getComparatorChain(List<EqMode> modes) {
        ArrayList<Comparator> comparatorChain = new ArrayList<Comparator>();
        if (modes.contains((Object)EqMode.IGNORE_DATES)) {
            comparatorChain.add(LENIENT_DATES_COMPARATOR);
        }
        if (modes.contains((Object)EqMode.IGNORE_DEFAULTS)) {
            comparatorChain.add(IGNORE_DEFAULTS_COMPARATOR);
        }
        comparatorChain.add(LENIENT_NUMBER_COMPARATOR);
        comparatorChain.add(SIMPLE_CASES_COMPARATOR);
        if (modes.contains((Object)EqMode.IGNORE_ORDER)) {
            comparatorChain.add(LENIENT_ORDER_COMPARATOR);
        } else {
            comparatorChain.add(COLLECTION_COMPARATOR);
        }
        comparatorChain.add(MAP_COMPARATOR);
        comparatorChain.add(HIBERNATE_PROXY_COMPARATOR);
        comparatorChain.add(OBJECT_COMPARATOR);
        return comparatorChain;
    }
}

