/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.report;

import ext.jtester.org.apache.commons.lang.ClassUtils;
import java.util.List;
import java.util.Map;
import org.jtester.hamcrest.matcher.property.difference.ClassDifference;
import org.jtester.hamcrest.matcher.property.difference.CollectionDifference;
import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.difference.DifferenceVisitor;
import org.jtester.hamcrest.matcher.property.difference.MapDifference;
import org.jtester.hamcrest.matcher.property.difference.ObjectDifference;
import org.jtester.hamcrest.matcher.property.difference.UnorderedCollectionDifference;
import org.jtester.hamcrest.matcher.property.report.DefaultDifferenceReport;
import org.jtester.hamcrest.matcher.property.report.DifferenceView;
import org.jtester.hamcrest.matcher.property.report.ObjectFormatter;

public class DefaultDifferenceView
implements DifferenceView {
    protected boolean outputtingUnorderedCollectionDifference = false;
    protected ObjectFormatter objectFormatter = new ObjectFormatter();
    protected DifferenceFormatterVisitor differenceFormatterVisitor = new DifferenceFormatterVisitor();

    public String createView(Difference difference) {
        return difference.accept(this.differenceFormatterVisitor, null);
    }

    protected String formatDifference(Difference difference, String fieldName) {
        return this.formatValues(fieldName, difference.getLeftValue(), difference.getRightValue());
    }

    protected String formatDifference(ObjectDifference objectDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Difference> fieldDifference : objectDifference.getFieldDifferences().entrySet()) {
            String innerFieldName = this.createFieldName(fieldName, fieldDifference.getKey(), true);
            result.append(fieldDifference.getValue().accept(this.differenceFormatterVisitor, innerFieldName));
        }
        return result.toString();
    }

    protected String formatDifferrence(ClassDifference classDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append("Expected: object of type ").append(ClassUtils.getShortClassName(classDifference.getLeftClass()));
        result.append(", actual: object of type ").append(ClassUtils.getShortClassName(classDifference.getRightClass())).append("\n");
        return result.toString();
    }

    protected String formatDifference(CollectionDifference collectionDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Integer, Difference> elementDifferences : collectionDifference.getElementDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, "[" + elementDifferences.getKey() + "]", false);
            result.append(elementDifferences.getValue().accept(this.differenceFormatterVisitor, innerFieldName2));
        }
        List<?> leftList = collectionDifference.getLeftList();
        List<?> rightList = collectionDifference.getRightList();
        for (Integer leftIndex : collectionDifference.getLeftMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + "]", false);
            result.append(this.formatValues(innerFieldName, leftList.get(leftIndex), (Object)DefaultDifferenceReport.MatchType.NO_MATCH));
        }
        for (Integer rightIndex : collectionDifference.getRightMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + rightIndex + "]", false);
            result.append(this.formatValues(innerFieldName, (Object)DefaultDifferenceReport.MatchType.NO_MATCH, rightList.get(rightIndex)));
        }
        return result.toString();
    }

    protected String formatDifference(MapDifference mapDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Object, Difference> valueDifference : mapDifference.getValueDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, this.formatObject(valueDifference.getKey()), true);
            result.append(valueDifference.getValue().accept(this.differenceFormatterVisitor, innerFieldName2));
        }
        Map<?, ?> leftMap = mapDifference.getLeftMap();
        Map<?, ?> rightMap = mapDifference.getRightMap();
        for (Object leftKey : mapDifference.getLeftMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(leftKey), true);
            result.append(this.formatValues(innerFieldName, leftMap.get(leftKey), ""));
        }
        for (Object rightKey : mapDifference.getRightMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(rightKey), true);
            result.append(this.formatValues(innerFieldName, rightMap.get(rightKey), ""));
        }
        return result.toString();
    }

    protected String formatObject(Object object) {
        if (object == DefaultDifferenceReport.MatchType.NO_MATCH) {
            return "--no match--";
        }
        return this.objectFormatter.format(object);
    }

    protected String formatDifference(UnorderedCollectionDifference unorderedCollectionDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(fieldName == null ? "" : fieldName + ": ");
        if (unorderedCollectionDifference.getRightList().size() != unorderedCollectionDifference.getLeftList().size()) {
            result.append("Collections have a different size: Expected " + unorderedCollectionDifference.getLeftList().size() + ", actual " + unorderedCollectionDifference.getRightList().size() + ".\n");
        }
        Map<Integer, Integer> bestMatchingIndexes = unorderedCollectionDifference.getBestMatchingIndexes();
        for (Map.Entry<Integer, Integer> bestMatchingIndex : bestMatchingIndexes.entrySet()) {
            String innerFieldName;
            int leftIndex = bestMatchingIndex.getKey();
            int rightIndex = bestMatchingIndex.getValue();
            if (leftIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[x," + rightIndex + "]", false);
                result.append(this.formatValues(innerFieldName, (Object)DefaultDifferenceReport.MatchType.NO_MATCH, unorderedCollectionDifference.getRightList().get(rightIndex)));
                continue;
            }
            if (rightIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + ",x]", false);
                result.append(this.formatValues(innerFieldName, unorderedCollectionDifference.getLeftList().get(leftIndex), (Object)DefaultDifferenceReport.MatchType.NO_MATCH));
                continue;
            }
            Difference difference = unorderedCollectionDifference.getElementDifference(leftIndex, rightIndex);
            if (difference == null) continue;
            String innerFieldName2 = this.createFieldName(fieldName, "[" + leftIndex + "," + rightIndex + "]", false);
            result.append(difference.accept(this.differenceFormatterVisitor, innerFieldName2));
        }
        return result.toString();
    }

    protected String formatValues(String fieldName, Object leftValue, Object rightValue) {
        String rightValueFormatted;
        String leftValueFormatted = this.formatObject(leftValue);
        String valuesFormattedOnOneLine = this.formatValuesOnOneLine(fieldName, leftValueFormatted, rightValueFormatted = this.formatObject(rightValue));
        if (valuesFormattedOnOneLine.length() < 110) {
            return valuesFormattedOnOneLine;
        }
        return this.formatValuesOnMultipleLines(fieldName, leftValueFormatted, rightValueFormatted);
    }

    protected String formatValuesOnOneLine(String fieldName, String leftValueFormatted, String rightValueFormatted) {
        StringBuilder result = new StringBuilder();
        if (fieldName != null) {
            result.append(fieldName).append(": ");
        }
        result.append("expected: ").append(leftValueFormatted);
        result.append(", actual: ").append(rightValueFormatted).append("\n");
        return result.toString();
    }

    protected String formatValuesOnMultipleLines(String fieldName, String leftValueFormatted, String rightValueFormatted) {
        StringBuilder result = new StringBuilder();
        if (fieldName != null) {
            result.append(fieldName).append(":\n");
        }
        result.append(" expected: ").append(leftValueFormatted).append("\n");
        result.append("   actual: ").append(rightValueFormatted).append("\n\n");
        return result.toString();
    }

    protected String createFieldName(String fieldName, String innerFieldName, boolean includePoint) {
        if (fieldName == null) {
            return innerFieldName;
        }
        StringBuilder result = new StringBuilder();
        result.append(fieldName);
        if (includePoint) {
            result.append(".");
        }
        result.append(innerFieldName);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DifferenceFormatterVisitor
    implements DifferenceVisitor<String, String> {
        protected DifferenceFormatterVisitor() {
        }

        @Override
        public String visit(Difference difference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(difference, fieldName);
        }

        @Override
        public String visit(ObjectDifference objectDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(objectDifference, fieldName);
        }

        @Override
        public String visit(ClassDifference classDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifferrence(classDifference, fieldName);
        }

        @Override
        public String visit(MapDifference mapDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(mapDifference, fieldName);
        }

        @Override
        public String visit(CollectionDifference collectionDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(collectionDifference, fieldName);
        }

        @Override
        public String visit(UnorderedCollectionDifference unorderedCollectionDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(unorderedCollectionDifference, fieldName);
        }
    }
}

