/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.report;

import ext.jtester.org.apache.commons.lang.ClassUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jtester.hamcrest.matcher.property.reflection.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFormatter {
    protected int maxDepth;

    public ObjectFormatter() {
        this(5);
    }

    public ObjectFormatter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String format(Object object) {
        StringBuilder result = new StringBuilder();
        this.formatImpl(object, 0, result);
        return result.toString();
    }

    protected void formatImpl(Object object, int currentDepth, StringBuilder result) {
        if ((object = HibernateUtil.getUnproxiedValue(object)) == null) {
            result.append(String.valueOf(object));
            return;
        }
        if (object instanceof String) {
            result.append('\"');
            result.append(object);
            result.append('\"');
            return;
        }
        if (object instanceof Number || object instanceof Date) {
            result.append(String.valueOf(object));
            return;
        }
        if (object instanceof Character) {
            result.append('\'');
            result.append(String.valueOf(object));
            result.append('\'');
            return;
        }
        Class dummyObjectClass = this.getDummyObjectClass();
        if (dummyObjectClass != null && dummyObjectClass.isAssignableFrom(object.getClass())) {
            result.append("Dummy<");
            result.append(object.toString());
            result.append(">");
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || type.isEnum()) {
            result.append(String.valueOf(object));
            return;
        }
        if (this.formatMock(object, result)) {
            return;
        }
        if (this.formatProxy(object, result)) {
            return;
        }
        if (type.getName().startsWith("java.lang")) {
            result.append(String.valueOf(object));
            return;
        }
        if (type.isArray()) {
            this.formatArray(object, currentDepth, result);
            return;
        }
        if (object instanceof Collection) {
            this.formatCollection((Collection)object, currentDepth, result);
            return;
        }
        if (object instanceof Map) {
            this.formatMap((Map)object, currentDepth, result);
            return;
        }
        if (currentDepth >= this.maxDepth) {
            result.append(ClassUtils.getShortClassName(type));
            result.append("<...>");
            return;
        }
        this.formatObject(object, currentDepth, result);
    }

    protected void formatArray(Object array, int currentDepth, StringBuilder result) {
        if (array instanceof byte[]) {
            result.append(Arrays.toString((byte[])array));
            return;
        }
        if (array instanceof short[]) {
            result.append(Arrays.toString((short[])array));
            return;
        }
        if (array instanceof int[]) {
            result.append(Arrays.toString((int[])array));
            return;
        }
        if (array instanceof long[]) {
            result.append(Arrays.toString((long[])array));
            return;
        }
        if (array instanceof char[]) {
            result.append(Arrays.toString((char[])array));
            return;
        }
        if (array instanceof float[]) {
            result.append(Arrays.toString((float[])array));
            return;
        }
        if (array instanceof double[]) {
            result.append(Arrays.toString((double[])array));
            return;
        }
        if (array instanceof boolean[]) {
            result.append(Arrays.toString((boolean[])array));
            return;
        }
        result.append("[");
        boolean notFirst = false;
        for (Object element : (Object[])array) {
            if (notFirst) {
                result.append(", ");
            } else {
                notFirst = true;
            }
            this.formatImpl(element, currentDepth + 1, result);
        }
        result.append("]");
    }

    protected void formatCollection(Collection<?> collection, int currentDepth, StringBuilder result) {
        result.append("[");
        boolean notFirst = false;
        for (Object element : collection) {
            if (notFirst) {
                result.append(", ");
            } else {
                notFirst = true;
            }
            this.formatImpl(element, currentDepth + 1, result);
        }
        result.append("]");
    }

    protected void formatMap(Map<?, ?> map, int currentDepth, StringBuilder result) {
        result.append("{");
        boolean notFirst = false;
        for (Map.Entry<?, ?> element : map.entrySet()) {
            if (notFirst) {
                result.append(", ");
            } else {
                notFirst = true;
            }
            this.formatImpl(element.getKey(), currentDepth, result);
            result.append("=");
            this.formatImpl(element.getValue(), currentDepth + 1, result);
        }
        result.append("}");
    }

    protected void formatObject(Object object, int currentDepth, StringBuilder result) {
        Class<?> type = object.getClass();
        result.append(ClassUtils.getShortClassName(type));
        result.append("<");
        this.formatFields(object, type, currentDepth, result);
        result.append(">");
    }

    protected void formatFields(Object object, Class clazz, int currentDepth, StringBuilder result) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length; ++i) {
            AccessibleObject field = fields[i];
            if (Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers()) || ((Field)field).isSynthetic()) continue;
            try {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(((Field)field).getName());
                result.append("=");
                this.formatImpl(((Field)field).get(object), currentDepth + 1, result);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
        for (Class superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            this.formatFields(object, superclazz, currentDepth, result);
        }
    }

    protected boolean formatMock(Object object, StringBuilder result) {
        try {
            Class proxyUtilsClass = this.getProxyUtilsClass();
            if (proxyUtilsClass == null) {
                return false;
            }
            String mockName = (String)proxyUtilsClass.getMethod("getMockName", Object.class).invoke(null, object);
            if (mockName == null) {
                return false;
            }
            result.append("Mock<");
            result.append(mockName);
            result.append(">");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected boolean formatProxy(Object object, StringBuilder result) {
        String className = ClassUtils.getShortClassName(object.getClass());
        int index = className.indexOf("..EnhancerByCGLIB..");
        if (index > 0) {
            result.append("Proxy<");
            result.append(className.substring(0, index));
            result.append(">");
            return true;
        }
        return false;
    }

    protected Class getDummyObjectClass() {
        try {
            return Class.forName("org.unitils.mock.dummy.DummyObject");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Class getProxyUtilsClass() {
        try {
            return Class.forName("org.unitils.mock.core.proxy.ProxyUtils");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

