/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.property.report;

import org.jtester.hamcrest.matcher.property.difference.Difference;
import org.jtester.hamcrest.matcher.property.report.DifferenceView;
import org.jtester.hamcrest.matcher.property.report.ObjectFormatter;

public class SimpleDifferenceView
implements DifferenceView {
    private ObjectFormatter objectFormatter = new ObjectFormatter();

    public String createView(Difference difference) {
        String expectedStr = this.objectFormatter.format(difference.getLeftValue());
        String actualStr = this.objectFormatter.format(difference.getRightValue());
        String formattedOnOneLine = this.formatOnOneLine(expectedStr, actualStr);
        if (AssertionError.class.getName().length() + 2 + formattedOnOneLine.length() < 110) {
            return formattedOnOneLine;
        }
        return this.formatOnTwoLines(expectedStr, actualStr);
    }

    protected String formatOnOneLine(String expectedStr, String actualStr) {
        return "Expected: " + expectedStr + ", actual: " + actualStr;
    }

    protected String formatOnTwoLines(String expectedStr, String actualStr) {
        StringBuilder result = new StringBuilder();
        result.append("\nExpected: ").append(expectedStr);
        result.append("\n  Actual: ").append(actualStr);
        return result.toString();
    }
}

