/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.string;

import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.TypeSafeMatcher;
import org.jtester.hamcrest.matcher.string.StringMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringContainMatcher
extends TypeSafeMatcher<String> {
    private final String[] expecteds;
    private final StringMode[] modes;
    private String message = "";

    public StringContainMatcher(String[] expectedSubString, StringMode[] modes) {
        this.expecteds = expectedSubString;
        this.modes = modes;
    }

    @Override
    public void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("was \"").appendText(item).appendText("\"");
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a string containing ").appendValueList("", ", ", "", this.expecteds);
        if (this.modes != null && this.modes.length > 0) {
            description.appendText(" by modes" + StringMode.toString(this.modes));
        }
        if (!"".endsWith(this.message)) {
            description.appendText(", but ").appendText(this.message);
        }
    }

    @Override
    protected boolean matchesSafely(String item) {
        if (item == null) {
            this.message = "the actual can't be null.";
            return false;
        }
        String actual = StringMode.getStringByMode(item, this.modes);
        for (String sub : this.expecteds) {
            if (sub == null) {
                this.message = "the sub string can't be null.";
                return false;
            }
            String expected = StringMode.getStringByMode(sub, this.modes);
            boolean result = actual.contains(expected);
            if (result) continue;
            this.message = String.format("the string[%s] not contain substring[%s].", actual, expected);
            return false;
        }
        return true;
    }

    public static StringContainMatcher contains(String sub) {
        StringContainMatcher matcher = new StringContainMatcher(new String[]{sub}, null);
        return matcher;
    }
}

