/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.string;

import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.Factory;
import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.TypeSafeMatcher;
import org.jtester.hamcrest.matcher.string.StringMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringContainsInOrder
extends TypeSafeMatcher<String> {
    private final Iterable<String> substrings;
    private final StringMode[] modes;
    String message = "";

    public StringContainsInOrder(Iterable<String> substrings) {
        this.substrings = substrings;
        this.modes = new StringMode[0];
    }

    public StringContainsInOrder(Iterable<String> substrings, StringMode[] modes) {
        this.substrings = substrings;
        this.modes = modes;
    }

    @Override
    public boolean matchesSafely(String s) {
        if (s == null) {
            this.message = "the actual can't be null.";
            return false;
        }
        String actual = StringMode.getStringByMode(s, this.modes);
        int fromIndex = 0;
        for (String substring : this.substrings) {
            if (substring == null) {
                this.message = "the sub string can't be null.";
                return false;
            }
            String expected = StringMode.getStringByMode(substring, this.modes);
            int index = actual.indexOf(expected, fromIndex);
            if (index == -1) {
                this.message = String.format("the string[%s] not contain substring[%s] from index %d.", actual, expected, fromIndex);
                return false;
            }
            fromIndex = index + expected.length();
        }
        return true;
    }

    @Override
    public void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("was \"").appendText(item).appendText("\"");
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a string containing ").appendValueList("", ", ", "", this.substrings);
        if (this.modes != null && this.modes.length > 0) {
            description.appendText(" in order by modes" + StringMode.toString(this.modes));
        }
        if (!"".endsWith(this.message)) {
            description.appendText(", but ").appendText(this.message);
        }
    }

    @Factory
    public static Matcher<String> stringContainsInOrder(Iterable<String> substrings) {
        return new StringContainsInOrder(substrings);
    }
}

