/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.hamcrest.matcher.string;

import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StringMode {
    IgnoreCase{

        public String process(String input) {
            if (input == null) {
                return null;
            }
            return input.toLowerCase();
        }
    }
    ,
    IgnoreSpace{

        public String process(String input) {
            char[] chars;
            if (input == null) {
                return null;
            }
            StringBuilder buff = new StringBuilder();
            for (char ch : chars = input.toCharArray()) {
                if (StringHelper.isSpace(ch)) continue;
                buff.append(ch);
            }
            return buff.toString();
        }
    }
    ,
    IgnoreQuato{

        public String process(String input) {
            if (input == null) {
                return null;
            }
            int length = input.length();
            StringBuilder buff = new StringBuilder();
            char[] chars = input.toCharArray();
            for (int index = 0; index < length; ++index) {
                char ch = chars[index];
                if (ch == '\"' || ch == '\'') continue;
                buff.append(ch);
            }
            return buff.toString();
        }
    }
    ,
    SameAsSpace{

        public String process(String input) {
            if (input == null) {
                return null;
            }
            int length = input.length();
            StringBuilder buff = new StringBuilder();
            char[] chars = input.toCharArray();
            for (int index = 0; index < length; ++index) {
                char ch = chars[index];
                if (StringHelper.isSpace(ch)) {
                    buff.append(' ');
                    index = this.skipSpaceChar(chars, index + 1, length);
                    continue;
                }
                buff.append(ch);
            }
            return buff.toString();
        }

        private int skipSpaceChar(char[] chars, int start, int length) {
            for (int index = start; index < length; ++index) {
                char ch = chars[index];
                if (StringHelper.isSpace(ch)) continue;
                return index - 1;
            }
            return length;
        }
    }
    ,
    SameAsQuato{

        public String process(String input) {
            if (input == null) {
                return null;
            }
            int length = input.length();
            StringBuilder buff = new StringBuilder();
            char[] chars = input.toCharArray();
            for (int index = 0; index < length; ++index) {
                char ch = chars[index];
                if (ch == '\"') {
                    buff.append('\'');
                    continue;
                }
                buff.append(ch);
            }
            return buff.toString();
        }
    }
    ,
    SameAsSlash{

        public String process(String input) {
            if (input == null) {
                return null;
            }
            int length = input.length();
            StringBuilder buff = new StringBuilder();
            char[] chars = input.toCharArray();
            for (int index = 0; index < length; ++index) {
                char ch = chars[index];
                if (ch == '/') {
                    buff.append('\\');
                    continue;
                }
                buff.append(ch);
            }
            return buff.toString();
        }
    };


    public abstract String process(String var1);

    public static String getStringByMode(String input, StringMode ... modes) {
        if (modes == null || modes.length == 0) {
            return input;
        }
        String output = input;
        for (StringMode mode : modes) {
            output = mode.process(output);
        }
        return output;
    }

    public static String toString(StringMode ... modes) {
        if (modes == null || modes.length == 0) {
            return "[]";
        }
        StringBuilder buff = new StringBuilder("[");
        for (StringMode mode : modes) {
            buff.append(mode.name()).append(" ");
        }
        buff.append("]");
        return buff.toString();
    }
}

